#ifndef VRDEFS_H
#define VRDEFS_H

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

#ifndef MIN
#define MIN(a,b)	((a)<(b)?(a):(b))
#define MAX(a,b)	((a)<(b)?(b):(a))
#endif
#define ABSF(f)		((f) > 0 ? (f) : (-(f)))

#ifndef RAND_MAX
#define RAND_MAX	32767
#endif

#define NN(s)		((s) ? (s) : "")

#define CROP(a,x,b)	MIN(MAX(a,x),b)
#define SWAP(a,b,t)	{ t=a; a=b; b=t; }

#define smartFree(x)   { if (x != NULL) { free(x); x = NULL; } }
#define smartDelete(x) { if (x != NULL) { delete x; x = NULL; } }

#ifndef M_PI
#define M_PI		3.141592
#define M_PI_2		1.570796
#endif
#define M_2PI		6.283185
#define M_2PI_5		1.256637
#define M_PI_180	0.017453

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#define PATH_LEN	128
#define MESS_LEN	256
#define CHAN_LEN	32
#define GROUP_LEN	16
#define URL_LEN		256
#define OBJNAME_LEN	64	// max lenght of object name
#define HNAME_LEN	11	// max length of understandable name
#define PROPSNUMBER	20	// number max of object's properties
#define BUTTONSNUMBER	32	// number max of buttons
#define ACTIONSNUMBER	32	// number max of actions

#define NEEDLOOPBACK	0	// get multicast sockets to use loopback

#define MANAGER_NAME	"manager"

#endif  // VRDEFS_H
