#ifndef VRNETDB_H
#define VRNETDB_H

void initResolve(void);
struct hostent * my_getipnodebyname(const char *hostname, int af);
struct hostent * my_getipnodebyaddr(const char *hostaddr, int af);
struct hostent * my_gethostbyname(const char *hostname, int af);
struct hostent * my_gethostbyaddr(const char *hostaddr, int af);
struct hostent * my_gethostbyname_r(const char *hostname, int af);
struct hostent * my_gethostbyaddr_r(const char *hostaddr, int af);
struct servent * my_getservbyname(const char *servname);
struct servent * my_getservbyname_r(const char *servname);
void my_free_hostent(struct hostent *hp);
const char * my_inet_ntop(const int af, const void *addr);
const char * inet4_ntop(const void *addr);
const char * inet6_ntop(const void *addr);
int my_inet_pton(const int af, const char *name, void *addr);
int inet4_pton(const char *name, void *addr);
int inet6_pton(const char *name, void *addr);

#endif // VRNETDB_H
