#ifndef NETDEFS_H
#define NETDEFS_H

#define RTP
#define RTCP

#define MAX_VERSION_JUMP 10

/* packet format */
#define PKTSIZE			536	// Max packet size
#define RTP_HDR_SIZE		12	// RTP header length

#define VREP_VERSION		2
//+========+========+========+========+
//|  vers  | family |  flags |  len   |
//+========+========+========+========+
//|              payload              |
//|                ...                |
//+--------+--------+--------+--------+
#define PAYLOAD_TYPE		65	// vreng payload type
#define PAYLOAD_HDR_VERSION	0
#define PAYLOAD_HDR_FAMILY	1
#define PAYLOAD_HDR_FLAGS	2
#define PAYLOAD_HDR_LEN		3
#define PAYLOAD_HDR_SIZE	4

/* for compatibility with older protocol */
//+========+========+========+========+
//|  len   |        hostid...         |
//+--------+--------+--------+========+
//|.hostid |      portid     |payload |
//+========+========+========+--------+
//|              payload              |
//|                ...                |
//+--------+--------+--------+--------+
#define PAYLOAD_TYPE_V1		105	// vreng payload type
#define PAYLOAD_HDR_LEN_V1	0
#define PAYLOAD_HDR_SRCID_V1	1
#define PAYLOAD_HDR_PORTID_V1	5
#define PAYLOAD_HDR_SIZE_V1	7

/* command types */
#define VREP_CREATE		1
#define VREP_DELTA		2
#define VREP_QUERY		3
#define VREP_DELETE		4
#define VREP_PERSIST_SET	10
#define VREP_PERSIST_INFO	11
#define VREP_PERSIST_RESET	12
#define VREP_WORLD_SET		13
#define VREP_WORLD_INFO		14
#define VREP_WORLD_RESET	15
#define VREP_ADDRESS_REQ	20
#define VREP_ADDRESS_RET	21
#define VREP_ADDRESS_REL	22
#define VREP_ADDRESS_REN	23

#define VREP_CREATE_V1	'C'
#define VREP_DELTA_V1	'd'
#define VREP_QUERY_V1	'?'
#define VREP_DELETE_V1	'D'

/* socket address indexes */
#define SA_RTP		0
#define SA_RTCP		1
#define SA_RTP_R	2
#define SA_RTCP_R	3
#define SA_UDP		4

/* socket descriptor indexes */
#define SD_R_RTP	0
#define SD_W_RTP	1
#define SD_R_RTCP	2
#define SD_W_RTCP	3
#define SD_R_UDP	4
#define SD_W_UDP	4

#define VRUM_PORT_OFFSET 1000
#define MCAST_PROXY	"mcast_proxy"
#define MPROXY_CTRL_PORT 3128
#define MPROXY_DATA_PORT 3129

#endif // NETDEFS_H
