#ifndef PKT_H
#define PKT_H

class Payload;
class Channel;

int sendPacket(const int fd, const uint8_t *pkt, const int pkt_len, const struct sockaddr_in *to);
/**<
 * Sends a packet
 * Returns result of sendto(): -1 if error, else >=0
 */

int recvPacket(const int fd, struct sockaddr_in *sender, Payload *ppload);
/**<
 * Receives a packet
 *
 * Puts datas into the Payload and sender into sender
 * -1 if error, else >=0
 * TODO:
 * decoding multi-messages packets
 */

int sendPayload(const struct sockaddr_in *to, Payload *ppload);
/**<
 * Sends a payload
 * TODO: sends queue to group messages into only one packet
 * called by sendObj* (proto.c)
 */

int sendRTCPPacket(const Channel *channel, const struct sockaddr_in *to, const uint8_t pt);
/**<
 * Sends a RTCP packet
 */

int recvRTCPPacket(struct sockaddr_in *sender, uint8_t *pkt, const int pkt_len);
/**<
 * Receives a RTCP packet
 */

int sendSRSDES(const Channel *, const struct sockaddr_in *);
/**<
 * Sends a compound RTCP SR+SDES
 */

#endif // PKT_H
