#ifndef RTPSESS_H
#define RTPSESS_H

#include "rtp.h"

#define	RTPNAME_LEN	32
#define CNAME_LEN	64
#define EMAIL_LEN	32
#define TOOL_LEN	16


/**
 * SDES item
 */
typedef struct _sitem {
  uint8_t	si_type;
  uint8_t	si_len;
  uint8_t 	*si_str;
  struct _sitem *si_next;
} SdesItem;

/**
 * Source Class
 * Informations on a RTP source
 */
class Source {
 public:
  uint32_t	ssrc;
  uint32_t	extended_max;
  uint32_t	expected;
  uint32_t	lost;
  sourceInfos	s;
  SdesItem	sdes;		/* sdes from the source, if we received it */
  rtcp_sr_t	sr;
  rtcp_rr_t	rr;
  class Source	*next;

  Source(const uint32_t ssrc);
  /**< creates a new source */

  virtual ~Source();

  void dump();

  static Source * getSource(const uint32_t ssrc);
  static uint16_t getSourcesNumber();
  static uint16_t getMembersNumber();
  static void dumpAll();
};

/**
 * Session Class
 * Structure of a RTP session
 */
class Session {
 public:
  uint32_t	ssrc;
  uint32_t	group;
  uint16_t	rtp_port;
  uint16_t	rtcp_port;
  uint8_t	ttl;
  uint8_t	mode;		// WORLD, MANAGER
  rtp_hdr_t	rtp_hdr;	// session rtp header
  uint16_t	rtp_seq;	// sequence number
  rtcp_sr_t	sr;		// sender report
  class Source	*source;	// Informations on sources
  uint16_t	nbsources;	// amount of sources
  SdesItem	*mysdes;	// my own sdes
  class Session	*next;

  Session();
  virtual ~Session();

  virtual uint32_t createSession(uint32_t group, uint16_t port, uint8_t ttl, uint32_t ssrc);
  /**< creates a new session, called by channel */

  virtual void buildRtpHeader(rtp_hdr_t *pkt, const uint32_t ssrc);
  /**< builds a RTP header */

  virtual void deleteSourceBySsrc(const uint32_t ssrc);

  virtual void incrSources();

  virtual void createMySdes();
  virtual void refreshMySdes();
  virtual void freeMySdes();
  virtual void dump();
  virtual void statRTP();

  static void deleteSessionBySsrc(const uint32_t ssrc);
  static void clearSessionsList();
  static void dumpAll();
};

/**
 * Rtp Class
 */
class Rtp {
 public:
  static uint16_t createSeq();
  static uint32_t createSsrc(const int value);
  static void initSeq(sourceInfos *s, const uint16_t seq);
  static int updateSeq(sourceInfos *s, const uint16_t seq);

  static const char * getRtcpName();
  static const char * getRtcpEmail();
  static const char * getRtpName(char *name);
  static char * getRtcpTool();
  static SdesItem * allocSdesItem();
  static bool isSdesType(const uint8_t sdes_type);
  static char * getSdesItemBySsrc(const uint8_t type, const uint32_t ssrc);
  static char * getRtcpNameBySsrc(const uint32_t ssrc);
  static char * getRtcpEmailBySsrc(const uint32_t ssrc);
  static char * getRtcpToolBySsrc(const uint32_t ssrc);
};

#endif // RTPSESS_H
