#include "global.h"
#include "images.h"


struct bmp_header {
  uint8_t magic1;	// = 'B'	:0
  uint8_t magic2;	// = 'M'	:1
  int32_t file_size;	// 		:2
  int32_t reserved;	// 		:6
  int32_t data_offset;	// = 54 0x36	:10
  int32_t header_size;	// = 40 0x28	:14
  int32_t width;	// 		:18
  int32_t height;	// 		:22
  int16_t planes;	// = 1		:26
  int16_t bit_count;	// 1..24	:28
  int32_t compression;	// = 0		:30
  int32_t image_size;	// 		:34
  int32_t x_ppm;	// X pix/meter	:38
  int32_t y_ppm;	// Y pix/meter	:42
  int32_t colors_used;	// 		:46
  int32_t colors_vip;	// colors	:50
};			// 		:54

static uint32_t getshort(FILE *fp)
{
  int c, c1;
  c = getc(fp);  c1 = getc(fp);
  return ((uint32_t) c) + (((uint32_t) c1) << 8);
}

static uint32_t getint(FILE *fp)
{
  int c, c1, c2, c3;
  c = getc(fp);  c1 = getc(fp);  c2 = getc(fp);  c3 = getc(fp);
  return ((uint32_t) c) +
         (((uint32_t) c1) << 8) +
         (((uint32_t) c2) << 16) +
         (((uint32_t) c3) << 24);
}

/** Load a 24bpp BMP image */
Image * loadBMP(void *texc, ImageReader read_func)
{
  int32_t width, height;
  int32_t file_size, data_offset, image_size;
  int16_t compression, bit_count;
  int magic1, magic2;

  ImgReader *ir = new ImgReader(texc, read_func);
  TextureCacheEntry *tc = (TextureCacheEntry *) texc;

  FILE *fp;
  char filename[64];

  for (int i=0; i<2; i++) {	//FIXME: first is bad, second is ok ???
    if ((fp = ir->downloadInCache(tc->texurl, filename, 0)) == NULL) {
      delete ir;
      return NULL;
    }

    /* we read the header */
    magic1 = getc(fp); magic2 = getc(fp);
    if (magic1 != 'B' || magic2 != 'M') {
      error("LoadBMP: %s not a bmp file magic=%c%c", filename, magic1, magic2);
      if (i == 1) {
        delete ir;
        return NULL;
      }
      fclose(fp);
    }
  }
  delete ir;

  getint(fp);		// reserved and ignored
  getint(fp);		// file_size wrong
  data_offset = getint(fp);
  getint(fp);		// header_size
  width = getint(fp);
  height = getint(fp);
  getshort(fp);		// planes
  bit_count = getshort(fp);
  if (bit_count != 24) {
    error("loadBMP: don't support %d bpp", bit_count);
    fclose(fp);
    return NULL;
  }
  compression = getint(fp);
  if (compression != 0) {
    error("loadBMP: compression not supported");
    fclose(fp);
    return NULL;
  }
  image_size = getint(fp);
  fseek(fp, 0L, 2);
  file_size = ftell(fp);
  if (image_size == 0)
    image_size = file_size - data_offset;

  trace(DBG_VGL, "loadBMP: width=%d height=%d bpp=%d image_size=%d",
        width, height, bit_count, image_size);

  Image *image = new Image(width, height, IMAGE_RGB, IMAGE_FIX);
  if (! image) {
    error("LoadBMP: can't new image");
    fclose(fp);
    return NULL;
  }

  // we read the data
  fseek(fp, (long) data_offset, 0);
  fread((char *) image->pixmap, 1, image_size, fp);
  fclose(fp);

  //Inverse R et B
  for (int i=0; i < width*height ; i++) {
    uint8_t t = image->pixmap[i*3];
    image->pixmap[i*3] = image->pixmap[i*3+2];
    image->pixmap[i*3+2] = t;
  }
  return image;
}
