// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONEFACTORY_H
#define BONEFACTORY_H

#include "boneIO.h"
#include "boneVect3d.h"
#include "boneMesh3d.h"
#include "boneVert.h"

class Factory {
 public:

  Factory() {};
  virtual ~Factory() {};

  static void buildSphere(Mesh3D *result,
			float radius = 1.,
			int cpt1 = 8,
			int cpt2 = 8,
			float centerx = 0.,
			float centery = 0.,
			float centerz = 0.);
  static void buildTorus(Mesh3D *result,
			float bigRadius = 1.,
			float littleRadius = 0.3,
			int cpt1 = 8,
			int cpt2 = 8,
			float centrex = 0.,
			float centrey = 0.,
			float centrez = 0.);
  static void buildCylinder(Mesh3D *result,
			float radius = 1.,
			float height = 2.,
			int cpt1 = 8,
			int cpt2 = 8,
			float centrex = 0.,
			float centrey = 0.,
			float centrez = 0.);
  static void readVRMLfile(Mesh3D *result,
			char *filename,
			float size = 1.,
			float centrex = 0.,
			float centrey = 0.,
			float centrez = 0.,
			int colorMask = 0);
  static void readVRE3Dfile(Mesh3D *result,
			BoneVertex *skeletonRoot,
			char *filename,
			float size = 1.);
  static void writeVRE3Dfile(Mesh3D *outMesh,
			BoneVertex *skeletonRoot,
			char *filename);
  static void readTGA(char *filename, int **buffer, int *width, int *height);
};

#endif // BONEFACTORY_H
