// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONETRIANGLE_H
#define BONETRIANGLE_H

#include "boneVertex.h"

class TRIANGLE {
 public:

  // Datas for the triangle class
  Vertex * vertex1; float u1, v1; int index1;
  Vertex * vertex2; float u2, v2; int index2;
  Vertex * vertex3; float u3, v3; int index3;
  Vect3D initialNormal;
  Vect3D currentNormal;
  float colorRed, colorGreen, colorBlue, colorAlpha; // Initial colors
  float finalRed, finalGreen, finalBlue, finalAlpha; // Projected colors

  // Construct / destruct
  inline TRIANGLE()
  {
    vertex1 = NULL;
    vertex2 = NULL;
    vertex3 = NULL;

    initialNormal.reset();
    currentNormal.reset();
    setColor();
  }

  virtual ~TRIANGLE() {}

  // Accessing datas
  void addVertex(Vertex *zeVertex, int index, float u=-1.0f, float v=-1.)
  {
    if (( u == -1.0 ) && ( v == -1.0 )) {
       u = zeVertex -> initialPosition.x / 3.0f;
       v = zeVertex -> initialPosition.y / 3.0f;
    }
    if (vertex1 == NULL) {
      vertex1 = zeVertex; index1 = index; u1 = u; v1 = v;
    }
    else if (vertex2 == NULL) {
      vertex2 = zeVertex; index2 = index; u2 = u; v2 = v;
    }
    else if (vertex3 == NULL) {
      vertex3 = zeVertex; index3 = index; u3 = u; v3 = v;
    }
}

  void rebuildNormal()
  {
    Vect3D edge1;
    Vect3D edge2;
    edge1 = vertex1->initialPosition - vertex2->initialPosition;
    edge2 = vertex1->initialPosition - vertex3->initialPosition;
    initialNormal.crossProduct(edge1, edge2);
    initialNormal.normalize();
    currentNormal = initialNormal;
  }

  void setColor(float r=0.5f, float g=0.5f, float b=0.5f, float a=1.)
  {
    colorRed   = finalRed   = r;
    colorGreen = finalGreen = g;
    colorBlue  = finalBlue  = b;
    colorAlpha = finalAlpha = a;
  }
};

#endif // BONETRIANGLE_H
