// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONEVERTEX_H
#define BONEVERTEX_H

#include "boneVect3d.h"
#include "boneList.h"

class LINK;

class Vertex {
 public:

  // Champs de la classe vertex
  Vect3D initialPosition;
  Vect3D currentPosition;
  Vect3D initialNormal;
  Vect3D currentNormal;

  // -> Liens
  LIST < LINK > linkList;
  LINK **       link;
  int           links;
  int           linkListCompiled;

  // -> Coordonnees de mapping
  float u,v;

  // Constructeurs / destructeur
  Vertex();
  Vertex(Vect3D & zePosition);
  Vertex(Vect3D * zePosition);
  Vertex(float ox, float oy, float oz);
  virtual ~Vertex() {}

  // Acces aux champs 
  void setPosition(Vect3D & zePosition);
  void setPosition(Vect3D * zePosition);

  // Gestion des liens
  void addLink(LINK *zeLink);
  void removeLink(LINK *zeLink);

  // Acces aux champs de transformation initiaux
  void compileLinkList();
};

#endif // BONEVERTEX_H
