#ifndef GCONTEXT_H
#define GCONTEXT_H

/**
 * VGContext Class
 *
 * OpenGL Graphic Context
 */
class VGContext {
 public:
  class Solid	*first_solid, *last_solid;
  V3		bbox_min;
  V3		bbox_max;
  int		first_bbox;
  M4		camera_pos;
  bool		quality;

  VGContext();

  virtual void setMinMaxBB(float *v);
  virtual void getMinMaxBB(V3 *bbmax, V3 *bbmin, uint16_t frame);
  virtual void eyePosition(float *gl_mat);
  virtual void setCameraPosition(M4 *vr_mat);
  virtual void renderSolids();
  virtual Solid * getSolidByNumber(int number);
};

extern VGContext *gcontext;	// graphic context pointer

#endif  // GCONTEXT_H
