#ifndef IMAGES_H
#define IMAGES_H

#include "texture.h"	// ImageReader

/* we only deal with 8 bits RGB images */
#define IMAGE_BW	1
#define IMAGE_BWA	2
#define IMAGE_RGB	3
#define IMAGE_RGBA	4

#define IMAGE_FIX	0
#define IMAGE_ANIM	1

#define NORM8_BITS	8
#define NORM16_BITS	16
#define NORM_8		(1 << NORM8_BITS)


/**
 * Image Class
 * Pixmap structure
 */
class Image {
 public:
  uint16_t xsize;	// image width in pixels
  uint16_t ysize;	// image height in pixels
  uint8_t format;	// bytes per pixel
  uint8_t type;		// type
  uint8_t *pixmap;	// image data

  Image(const uint16_t xsize, const uint16_t ysize, const uint8_t format, const uint8_t type);
  ///< creates a new image

  virtual ~Image();
  ///< frees current image

  static Image * resizeImage(const uint16_t xnew, const uint16_t ynew, const uint8_t znew, uint8_t type, const Image *old);
  ///< resizes this image
};

/**
 * ImgReader Class
 */
class ImgReader {
 public:
  void *img_hdl;		// handle (texc)
  ImageReader read_func;	// http function
  int ch;			// work char

  ImgReader();
  ImgReader(void *_texc, ImageReader _read_func);

  virtual void get_ch();
  virtual void get_ch1();
  virtual int get_int();
  virtual void skip_spaces();

  virtual FILE * downloadInTmp();
  virtual FILE * downloadInCache(const char *url, char *filename, bool flagclo);
  virtual void unlinkInTmp(char *filename);
};

#if 0	// TODO
struct Anim_Image {
  Image image;
  struct Anim_Image *next;
};

class Image_Anim : public Image {
  float delay;
  uint16_t nb_images;
  Anim_Image *images;

  //void freeAnim();
};
#endif	// TODO

void imgClearBuf(void);
uint8_t imgGetC(void *texhdl, ImageReader read_func);

Image * loadPPM(void *texc, ImageReader rf);
Image * loadPGM(void *texc, ImageReader rf);
Image * loadGIF(void *texc, ImageReader rf);
Image * loadJPG(void *texc, ImageReader rf);
Image * loadPNG(void *texc, ImageReader rf);
Image * loadPCX(void *texc, ImageReader rf);
Image * loadXPM(void *texc, ImageReader rf);
Image * loadSGI(void *texc, ImageReader rf);
Image * loadBMP(void *texc, ImageReader rf);

#endif // IMAGES_H
