#ifndef TEXTURE_H
#define TEXTURE_H

#if WITH_TINYGL
#define TEXTURE_SIZE 256
#define TEXTURE_INTERNAL_FORMAT 3
#else
#define TEXTURE_SIZE 128	// originaly 256
#define TEXTURE_INTERNAL_FORMAT GL_RGB
#endif
#define MIME_LEN 32

#if 0 //pdimg
typedef int (*ImageReader) (char *buf, const int len);
#else
typedef int (*ImageReader) (void *texc, char *buf, const int len);
#endif //pdimg
//pd typedef void (*ImageDisplayer) (void *texc, Image *image);

/**
 * TextureCacheEntry Class
 * describes a texture entry in the cache
 */
class TextureCacheEntry {
 private:
  bool loaded;			// load flag
  TextureCacheEntry *next;

 public:
  int  texnum;			// texture number
  class Http *http;		// handle
  class Image *image;		// image structure
  char texurl[URL_LEN];		// url where is the texture
  char texmime[MIME_LEN];	// mime type of the texture

  TextureCacheEntry();
  virtual ~TextureCacheEntry();

#if 0 //pdimg
  virtual int readImage(char *buf, const int len);	//pd
#endif //pdimg

#if 0 //pdimg
  virtual void textureHttpReader(Http *_http); //pd
#else
  static void textureHttpReader(void *_texc, Http *_http); //pd
#endif //pdimg

  static void initCache(const int quality);
  static void closeCache();
  static int getFromCache(const char *url);
  static int getCurrentNumber();
  static TextureCacheEntry * getEntryByUrl(const char *url);
  static TextureCacheEntry * getEntryByNumber(const int);
  static void updateTextures();

};

#endif // TEXTURE_H
