#include "global.h"
#include "http.h"	// Http::GetLine
#include "vnp.h"


static
void getVnp3i(char *s, int *a, int *b, int *c)
{
  uint32_t k = strlen(s);
  int x=0, y=-1, z=-1;

  for (uint32_t i=0; i < k; i++) {
    if ((s[i] == ' ') || (s[i] == '\n')) {
      s[i] = 0;
      if (y == -1)
        y = i+1;
      else if (z == -1)
        z = i+1;
    }
  }
  *a = atoi(&s[x]);
  *b = atoi(&s[y]);
  *c = atoi(&s[z]);
}

static
void getVnp3f(char *s, float *a, float *b, float *c, float scale)
{
  uint32_t k = strlen(s);
  int x=0, y=-1, z=-1;

  for (uint32_t i=0; i < k; i++) {
    if ((s[i] == ' ') || (s[i] == '\n')) {
      s[i] = 0;
      if (y == -1)
        y = i+1;
      else if (z == -1)
        z = i+1;
    }
  }
#ifdef VNP_SCALING
  *a = (float) atof(&s[x]) * scale;
  *b = (float) atof(&s[y]) * scale;
  *c = (float) atof(&s[z]) * scale;
#else
  *a = (float) atof(&s[x]);
  *b = (float) atof(&s[y]);
  *c = (float) atof(&s[z]);
#endif
}

void drawVnpModel(struct VnpModel *vnp)
{
  //pd1 glPushMatrix();
  glBegin(GL_TRIANGLES);
  for (int i=0; i < vnp->pn; i++) {
    int v1 = vnp->p[i*6];
    int v2 = vnp->p[i*6+1];
    int v3 = vnp->p[i*6+2];
    int n1 = vnp->p[i*6+3];
    int n2 = vnp->p[i*6+4];
    int n3 = vnp->p[i*6+5];

    glNormal3f(vnp->n[n1*3], vnp->n[n1*3+1], vnp->n[n1*3+2]);
    glVertex3f(vnp->v[v1*3], vnp->v[v1*3+1], vnp->v[v1*3+2]);
    glNormal3f(vnp->n[n2*3], vnp->n[n2*3+1], vnp->n[n2*3+2]);
    glVertex3f(vnp->v[v2*3], vnp->v[v2*3+1], vnp->v[v2*3+2]);
    glNormal3f(vnp->n[n3*3], vnp->n[n3*3+1], vnp->n[n3*3+2]);
    glVertex3f(vnp->v[v3*3], vnp->v[v3*3+1], vnp->v[v3*3+2]);
  }
  glEnd();
  //pd1 glPopMatrix();
}

void vnpModelHttpReader(void *avnp, Http *http)
{
  if (! http)
    return;

  struct VnpModel *vnp = (struct VnpModel *) avnp;
  char line[128];

  if (vnp->scale == 0)
    vnp->scale = 1.;

  httpClearBuf();

  /* Get info header: vertices_number normals_number polygons_number */
  http->GetLine(line);
  getVnp3i(line, &vnp->vn, &vnp->nn, &vnp->pn);

  /* Get vertices */
  vnp->v = new float[3 * vnp->vn];
  for (int i=0; i < vnp->vn; i++) {
    http->GetLine(line);
    getVnp3f(line, &vnp->v[i*3], &vnp->v[i*3+1], &vnp->v[i*3+2], vnp->scale);
  }

  /* Get normals */
  vnp->n = new float[3 * vnp->nn];
  for (int i=0; i < vnp->nn; i++) {
    http->GetLine(line);
    getVnp3f(line, &vnp->n[i*3], &vnp->n[i*3+1], &vnp->n[i*3+2], vnp->scale);
  }

  /* Get polygons */
  vnp->p = new int[6 * vnp->pn];
  for (int i=0; i < vnp->pn; i++) {
    http->GetLine(line);
    uint32_t k = strlen(line);
    for (uint32_t j=0; j < k; j++) {
      int a = 0;
      if (line[j] == 'v') a = j+2;
      if (line[j] == 'n') {
        line[j-1] = 0;
        getVnp3i(&line[a],   &vnp->p[i*6],   &vnp->p[i*6+1], &vnp->p[i*6+2]);
        getVnp3i(&line[j+2], &vnp->p[i*6+3], &vnp->p[i*6+4], &vnp->p[i*6+5]);
        break;
      }
    }
  }
}
