/*
 * Initialization module
 */

#include "global.h"
#include "gui.h"	// options GuiMainLoop
#include "net.h"
#include "channel.h"
#include "world.h"	// World::init
#include "thread.h"	// initThreads
#if WITH_MYSQL && defined(HAVE_LIBMYSQLCLIENT)
#include "vrmysql.h"	// VRSql
#endif

/* Global variables */
uint32_t debug = 0;	// debug flag
int vrengd = false;	// Vreng client
Universe *universe;
char **env;

static World *world;

Universe::Universe()
{
  ttlorigin = getTtl(options->channel);
  strcpy(nameinitial, DEF_HTTP_SERVER);
  strcpy(urlinitial, options->url);
}

/* World Initialization */
static void WorldInitCB()
{
  trace(DBG_INIT, "cfg initial = %s", universe->urlinitial);
  World::init(universe->urlinitial, options->nick, options->skinf, options->skinb);
  trace(DBG_INIT, "WO initialized");
  stopTime(&ptime_init);
}

int main(int argc, char *argv[], char *envp[])
{
  env = envp;
  startTime(&ptime_init);

  /* lower priority */
  initNice();

  /* System Infos */
  initsysinfo();

  /*  Arithmetic Initialization */
  initFloating();
  initTrigo();

  /* Environment Initialization */
  initEnv();
  parsePrefs();

  /* Vacs cache */
  Vac::getList();

  /* Options Initialization */
  GuiInitAndGetOptions(argc, argv);
  trace(DBG_INIT, "Options initialized");

  /* Simultaneous http connections Initialization */
  initThreads();
  trace(DBG_INIT, "Threads initialized");

  /* Signals Initialization */
  initSignals();
  trace(DBG_INIT, "Signals initialized");

#if WITH_MYSQL && defined(HAVE_LIBMYSQLCLIENT)
  VRSql::initVRSql();
#endif

  /* Network Initialization */
  trace(DBG_INIT, "options->channel=%s", options->channel);
  Channel::initNetwork();

  universe = new Universe();
  manager = new World();	// manager
  world   = new World();	// initial world

  World::setManagerChannelNameAndJoin(DEF_MANAGER_CHANNEL); // join manager chan
  strcpy(manager->name, MANAGER_NAME);

  World::setChannelNameAndJoin(options->channel);	// join initial channel
  trace(DBG_INIT, "channelinitial=%s", World::getChannelName());

  World::setLocalName(universe->urlinitial);
  getGroup(World::getChannelName(), universe->groupinitial);
  universe->portinitial = getPort(World::getChannelName());
  trace(DBG_INIT, "Network initialized");

  /* WorldInitCB fait en callback apres lancement de la main loop 
   * pour eviter une attente trop importante
   */
  GuiMainLoop(WorldInitCB);

  /* NOT_REACHED */
  return 0;
}
