#include "global.h"
#include "wo.h"
#include "user.h"

#include "vgl.h"	// getSolidBB
#include "gcontext.h"	// setCameraPosition


/** Updates an object Bounding Box */
void WObject::getBB()
{
  if (soh) {
    soh->getSolidBB(&pos.bbcenter, &pos.bbsize);
    //trace(DBG_FORCE, "getBB: soh=%p obj=%p", soh, soh->object);
  }
  //pd else
  //pd   error("getBB: FIXME soh=null po=%p null", this);
}

void WObject::setBB()
{
  trace(DBG_FORCE, "setBB1: bbox_min=%.2f,%.2f,%.2f bbox_max=%.2f,%.2f,%.2f",
        gcontext->bbox_min.v[0], gcontext->bbox_min.v[1], gcontext->bbox_min.v[2], 
        gcontext->bbox_max.v[0], gcontext->bbox_max.v[1], gcontext->bbox_max.v[2]); 
  if (soh) {
    soh->bbcenter = pos.bbcenter;
    soh->bbsize = pos.bbsize;
    trace(DBG_FORCE, "setBB: bbsize=%.2f,%.2f,%.2f bbcenter=%.2f,%.2f,%.2f",
        soh->bbsize.v[0], soh->bbsize.v[1], soh->bbsize.v[2],
        soh->bbcenter.v[0], soh->bbcenter.v[1], soh->bbcenter.v[2]);
    for (int i=0; i<3; i++) {
      gcontext->bbox_min.v[i] = pos.bbcenter.v[i] - pos.bbsize.v[i];
      gcontext->bbox_max.v[i] = pos.bbcenter.v[i] + pos.bbsize.v[i];
    }
    trace(DBG_FORCE, "setBB2: bbox_min=%.2f,%.2f,%.2f bbox_max=%.2f,%.2f,%.2f",
          gcontext->bbox_min.v[0], gcontext->bbox_min.v[1], gcontext->bbox_min.v[2], 
          gcontext->bbox_max.v[0], gcontext->bbox_max.v[1], gcontext->bbox_max.v[2]); 
  }
  else
    error("setBB: FIXME soh=null");
}

/** Saves current position and Bounding Box of an object */
void WObject::copyPosAndBB(Pos &newpos)
{
  newpos = pos;
}

void WObject::copyPosZAndBB(Pos &newpos)
{
  newpos.x = pos.x;
  newpos.y = pos.y;
  newpos.z = pos.z;
  newpos.bbcenter = pos.bbcenter;
  newpos.bbsize = pos.bbsize;
}

/** Saves current position and Bounding Box of an object */
void WObject::copyPositionAndBB(WObject *pcur)
{
  if (pcur) {
    pcur->setType(type);
    pcur->pos = pos;
  }
  else
    error("copyPositionAndBB: FIXME pdst is NULL");
}

/** Updates an object in 3D */
void WObject::updateAll3D()
{
  if (!soh)
    return;
  M4 matrix = MulM4(TranslateM4(pos.x, pos.y, pos.z),
				MulM4(RotateM4(pos.az, UZ),
                                      MulM4(RotateM4(pos.ay, UY),
			                    RotateM4(pos.ax, UX)
                                           )
                                     )
                   );
  soh->setSolidPosition(&matrix);
}

void WObject::update3D()
{
  if (!soh)
    return;
  M4 matrix = MulM4(TranslateM4(pos.x, pos.y, pos.z),
			        /* RotateM4(pos.az, UZ) */
				MulM4(RotateM4(pos.az, UZ),
			              RotateM4(pos.ax, UX)
                                )
                   );
  soh->setSolidPosition(&matrix);
}

/** Updates camera in 3D */
void WObject::updateCamera()
{
  M4 matrix = MulM4(RotateM4(-M_PI_2, UX),
                    MulM4(RotateM4(M_PI_2, UZ),
                          MulM4(RotateM4(pos.ax, UX),
                                MulM4(RotateM4(pos.ay, UY),
                                      MulM4(RotateM4(-pos.az, UZ),
                                            TranslateM4(-pos.x, -pos.y, -(pos.z + 0.5 * USER_DEFAULTHEIGHT))
                                           )
                                     )
                               )
                         )
                   );
  gcontext->setCameraPosition(&matrix);
}

/** Sets a WObject pointer to this object in the Solid */
void WObject::setObjectToSolid()
{
  if (soh && (! isBehavior(NO_SELECTABLE)))
    soh->object = this;
} 
