#ifndef ANDROID_H
#define ANDROID_H

#define ANDROID_TYPE 40
#define ANDROID_NAME "Android"
#define	ANDROID_INIT androidInitFuncList


#include "face.h"	// YR
#include "vnp.h"	// VnpModel


#define ANDROID_INACTIVE	0
#define ANDROID_PLAYING	1
#define ANDROID_LISTENING	2
#define ANDROID_UNICAST	0
#define ANDROID_MULTICAST	1

// Body
#ifdef VNP_SCALING
#define MAN_HEIGHT	69
#define MAN_HALF_HEIGHT	34.5
#define MAN_SCALE 	0.0247
#define MAN_MULT	40.5
#else
#define MAN_HEIGHT	1.70
#define MAN_HALF_HEIGHT	0.85
#define MAN_SCALE 	1
#define MAN_MULT	1
#endif

#define PHALANX2_LEN	0.012
#define PHALANX_LEN	0.012
#define FINGER_LEN	0.0375
#define HAND_LEN	0.10
#define FOREARM_LEN	0.178
#define ELBOW_RAD	0.025
#define ARM_LEN		0.165
#define SHOULDER_RAD	0.0025
#define HEAD_RAD	0.0075
#define NECK_LEN	0.05
#define FOOT_LEN	0.12
#define CALF_LEN	0.265
#define LEG_LEN		0.25
#define BUST_LEN	0.30


// BAP/FAP values
#define VAPS_PORT	4150
#define VAPS_OFFSET_PORT	10
#define VAPS_BUFSIZ	8192
#define HEAD_BAP_V31	"3.1"
#define HEAD_BAP_V32	"3.2"
#define HEAD_FAP_V20	"2.0"
#define HEAD_FAP_V21	"2.1"
#define TYPE_BAP_NULL	0
#define TYPE_BAP_V31	31	// 3.1
#define TYPE_BAP_V32	32	// 3.2
#define TYPE_FAP_V20	20	// 2.0
#define TYPE_FAP_V21	21	// 2.1
#define NUM_BAPS_V31	186	// Mpeg4 specif
#define NUM_BAPS_V32	296	// Mpeg4 specif
#define NUM_FAPS	68	// Mpeg4 specif

#define NUM_JOINTS	60

#define	PELVIC_TILT		1
#define	PELVIC_TORSION		2
#define	PELVIC_ROLL		3
#define	L_HIP_FLEXION		4
#define	R_HIP_FLEXION		5
#define	L_HIP_ABDUCT		6
#define	R_HIP_ABDUCT		7
#define	L_HIP_TWIST		8
#define	R_HIP_TWIST		9
#define	L_KNEE_FLEXION		10
#define	R_KNEE_FLEXION		11
#define	L_KNEE_TWIST		12
#define	R_KNEE_TWIST		13
#define	L_ANKLE_FLEXION		14
#define	R_ANKLE_FLEXION		15
#define	L_ANKLE_TWIST		16
#define	R_ANKLE_TWIST		17
#define	L_SUBTALAR		18
#define	R_SUBTALAR		19
#define	L_MID_FOOT		20
#define	R_MID_FOOT		21
#define	L_TOE_FLEXION		22
#define	R_TOE_FLEXION		23
#define	L_CLAV_ABDUCT		24
#define	R_CLAV_ABDUCT		25
#define	L_CLAV_ROTATE		26
#define	R_CLAV_ROTATE		27
#define	L_SCAP_ABDUCT		28
#define	R_SCAP_ABDUCT		29
#define	L_SCAP_ROTATE		30
#define	R_SCAP_ROTATE		31
#define	L_SHOULDER_FLEXION	32
#define	R_SHOULDER_FLEXION	33
#define	L_SHOULDER_ABDUCT	34
#define	R_SHOULDER_ABDUCT	35
#define	L_SHOULDER_TWIST	36
#define	R_SHOULDER_TWIST	37
#define	L_ELBOW_FLEXION		38
#define	R_ELBOW_FLEXION		39
#define	L_ELBOW_TWIST		40
#define	R_ELBOW_TWIST		41
#define	L_WRIST_FLEXION		42
#define	R_WRIST_FLEXION		43
#define	L_WRIST_PIVOT		44
#define	R_WRIST_PIVOT		45
#define	L_WRIST_TWIST		46
#define	R_WRIST_TWIST		47
#define	C1ROLL			48
#define	C1TORSION		49
#define	C1TILT			50
#define	C4ROLL			57
#define	C4TORSION		58
#define	C4TILT			59
#define	T1ROLL			69
#define	T1TORSION		70
#define	T1TILT			71
#define	T5ROLL			81
#define	T5TORSION		82
#define	T5TILT			83
#define	L1ROLL			105
#define	L1TORSION		106
#define	L1TILT			107
#define L_PINKY_FLEXION1	120
#define R_PINKY_FLEXION1	121
#define L_PINKY_PIVOTABDUCT	122
#define R_PINKY_PIVOTABDUCT	123
#define L_PINKY_TWISTING	124
#define R_PINKY_TWISTING	125
#define L_PINKY_FLEXION2	126
#define R_PINKY_FLEXION2	127
#define L_PINKY_FLEXION3	128
#define R_PINKY_FLEXION3	129
#define L_RING_FLEXION1		130
#define R_RING_FLEXION1		131
#define L_RING_PIVOTABDUCT	132
#define R_RING_PIVOTABDUCT	133
#define L_RING_TWISTING		134
#define R_RING_TWISTING		135
#define L_RING_FLEXION2		136
#define R_RING_FLEXION2		137
#define L_RING_FLEXION3		138
#define R_RING_FLEXION3		139
#define L_MIDDLE_FLEXION1	140
#define R_MIDDLE_FLEXION1	141
#define L_MIDDLE_PIVOTABDUCT	142
#define R_MIDDLE_PIVOTABDUCT	143
#define L_MIDDLE_TWISTING	144
#define R_MIDDLE_TWISTING	145
#define L_MIDDLE_FLEXION2	146
#define R_MIDDLE_FLEXION2	147
#define L_MIDDLE_FLEXION3	148
#define R_MIDDLE_FLEXION3	149
#define L_INDEX_FLEXION1	150
#define R_INDEX_FLEXION1	151
#define L_INDEX_PIVOTABDUCT	152
#define R_INDEX_PIVOTABDUCT	153
#define L_INDEX_TWISTING	154
#define R_INDEX_TWISTING	155
#define L_INDEX_FLEXION2	156
#define R_INDEX_FLEXION2	157
#define L_INDEX_FLEXION3	158
#define R_INDEX_FLEXION3	159
#define L_THUMB_FLEXION1	160
#define R_THUMB_FLEXION1	161
#define L_THUMB_PIVOTABDUCT	162
#define R_THUMB_PIVOTABDUCT	163
#define L_THUMB_TWISTING	164
#define R_THUMB_TWISTING	165
#define L_THUMB_FLEXION2	166
#define R_THUMB_FLEXION2	167
#define L_THUMB_FLEXION3	168
#define R_THUMB_FLEXION3	169
#if 1
#define	TR_VERTICAL		170
#define	TR_LATERAL		171
#define	TR_FRONTAL		172
#define	RT_BODY_TURN		173
#define	RT_BODY_ROLL		174
#define	RT_BODY_TILT		175
#else
#define	TR_VERTICAL		181
#define	TR_LATERAL		182
#define	TR_FRONTAL		183
#define	RT_BODY_TURN		184
#define	RT_BODY_ROLL		185
#define	RT_BODY_TILT		186
#endif

#define	UPPER_NECK		1
#define	L_SHOULDER		2
#define	L_ELBOW			3
#define	L_WRIST			4
#define	R_SHOULDER		5
#define	R_ELBOW			6
#define	R_WRIST			7
#define	L_HIP			8
#define	L_KNEE			9
#define	R_HIP			10
#define	R_KNEE			11
#define	L_ANKLE			12
#define	R_ANKLE			13
#define	PELVIC			14
#define	SPINAL			15
#define	LOWER_NECK		16

/**
 * Phalanx2
 */
class Phalanx2 {
  GLfloat length;
public:
  Phalanx2() {length = PHALANX2_LEN;}

  int drawPhalanx2();
};

/**
 * Phalanx
 */
class Phalanx {
  GLfloat length;
  GLfloat angle_bend_phalanx;
public:
  class Phalanx2 *pphalanx2;

  Phalanx(Phalanx2 *);

  int drawPhalanx();
  void bend_phalanx(GLfloat angle) {angle_bend_phalanx = angle;}
};

/**
 * Finger
 */
class Finger {
  GLfloat length;
  GLfloat angle_bend_finger;
  GLfloat angle_tilt_finger;
public:
  class Phalanx *pphalanx;

  Finger(Phalanx *);

  int drawFinger(class Android *);
  void bend_finger(GLfloat angle) {angle_bend_finger = angle;}
  void tilt_finger(GLfloat angle) {angle_tilt_finger = angle;}
};

/**
 * Hand
 */
class Hand {
  GLfloat length;
  GLfloat angle_bend_hand;
  GLfloat angle_tilt_hand;
  GLfloat angle_turn_hand;
public:
  class Finger *pfingers[5];

  Hand(Finger **);

  int drawHand(class Android *);
  void bend_hand(GLfloat angle) {angle_bend_hand = angle;}
  void tilt_hand(GLfloat angle) {angle_tilt_hand = angle;}
  void turn_hand(GLfloat angle) {angle_turn_hand = angle;}
};

/**
 * Forearm
 */
class Forearm {
  GLfloat length;
  GLfloat angle_bend_elbow;
  GLfloat angle_turn_elbow;
public:
  class Hand *phand;

  Forearm(Hand *);

  int drawForearm(class Android *);
  void bend_elbow(GLfloat angle) {angle_bend_elbow = angle;}
  void turn_elbow(GLfloat angle) {angle_turn_elbow = angle;}
};

/**
 * Arm
 */
class Arm {
  GLfloat length;
  GLfloat angle_raise_arm;
  GLfloat angle_rote_arm;
  GLfloat angle_turn_arm;
public:
  class Forearm *pforearm;

  Arm(Forearm *);

  int drawArm(class Android *);
  void raise_arm (GLfloat angle) {angle_raise_arm = angle-90;}
  void rote_arm(GLfloat angle) {angle_rote_arm = -angle;}
  void turn_arm(GLfloat angle) {angle_turn_arm = angle+90;}
};

/**
 * Shoulder
 */
class Shoulder {
  GLfloat radius;
  GLfloat distance_avance_shoulder;
  GLfloat distance_raise_shoulder;
public:
  class Arm *parm;

  Shoulder(Arm *);

  int drawSoulder(class Android *);
  void avance_shoulder(GLfloat distance) {distance_avance_shoulder = distance;}
  void raise_shoulder(GLfloat distance) {distance_raise_shoulder = distance;}
};

/**
 * Head
 */
class Head {
  GLfloat radius;
  GLfloat angle_bend_head;
  GLfloat angle_tilt_head;
  GLfloat angle_turn_head;
public:

  Head();

  int drawHead();
  void bend_head(GLfloat angle) {angle_bend_head = angle;}
  void tilt_head(GLfloat angle) {angle_tilt_head = angle;}
  void turn_head(GLfloat angle) {angle_turn_head = angle;}
};

/**
 * Neck
 */
class Neck {
  GLfloat length;
  GLfloat angle_bend_neck;
  GLfloat angle_tilt_neck;
  GLfloat angle_turn_neck;
public:
  class Head *phead;

  Neck(Head *);

  int drawNeck();
  void bend_neck(GLfloat angle) {angle_bend_neck = angle;}
  void tilt_neck(GLfloat angle) {angle_tilt_neck = angle;}
  void turn_neck(GLfloat angle) {angle_turn_neck = angle;}
};

/**
 * Foot
 */
class Foot {
  GLfloat length;
  GLfloat angle_bend_foot;
  GLfloat angle_tilt_foot;
  GLfloat angle_turn_foot;
  //pd GLfloat foot_diffuse[4];
public:

  Foot() {
    //pd foot_diffuse[0] = 0.96;
    //pd foot_diffuse[1] = 0.5;
    //pd foot_diffuse[2] = 0.95;
    //pd foot_diffuse[3] = 1.0;
    length = FOOT_LEN;
    angle_bend_foot = angle_tilt_foot = angle_turn_foot = 0;
  }

  int drawFoot(class Android *);
  void bend_foot(GLfloat angle) {angle_bend_foot = -angle;}
  void tilt_foot(GLfloat angle) {angle_tilt_foot = -angle;}
  void turn_foot(GLfloat angle) {angle_turn_foot = -angle;}
};

/**
 * Calf
 */
class Calf {
  GLfloat length;
  GLfloat angle_bend_knee;
  GLfloat angle_turn_knee;
public:
  class Foot *pfoot;

  Calf(Foot *);

  int drawCalf(class Android *);
  void bend_knee(GLfloat angle) {angle_bend_knee = -angle;}
  void turn_knee(GLfloat angle) {angle_turn_knee = -angle;}
};

/**
 * Leg
 */
class Leg {
  GLfloat length;
  GLfloat angle_raise_leg;
  GLfloat angle_rote_leg;
  GLfloat angle_turn_leg;
public:
  class Calf *pcalf;

  Leg(Calf *calf);

  int drawLeg(class Android *);
  void raise_leg(GLfloat angle) {angle_raise_leg = angle;}
  void rote_leg(GLfloat angle) {angle_rote_leg = angle;}
  void turn_leg(GLfloat angle) {angle_turn_leg = angle;}
};

/**
 * Bust
 */
class Bust {
  GLfloat length;
  GLfloat angle_roll_bust;
  GLfloat angle_tilt_bust;
  GLfloat angle_turn_bust;
public:
  class Leg *plegs[2];
  class Shoulder *pshoulders[2];
  class Neck *pneck;

  Bust(Leg **, Shoulder **, Neck *, class Android *);

  int drawBust(class Android *);
  void roll_bust(GLfloat angle) {angle_roll_bust = angle;}
  void tilt_bust( GLfloat angle) {angle_tilt_bust = angle;}
  void turn_bust(GLfloat angle) {angle_turn_bust = angle;}
};

/**
 * Joint-Points
 */
struct _jp {
  float x[NUM_JOINTS+1];
  float y[NUM_JOINTS+1];
  float z[NUM_JOINTS+1];
};

/**
 * Android Class
 */
class Android: public WObject {
 public:
  float rotx;
  float roty;
  float rotz;
  uint8_t numjoints;
  uint8_t status;
  uint8_t bfflag;	///< stream type bap-3.1, bap-3.2, fap
  float skin[4];	///< skin color

  class Phalanx2 *phalanx2[10]; 
  class Phalanx  *phalanx[10];
  class Finger	 *fingers_r[5], *fingers_l[5];
  class Hand	 *hand_r, *hand_l;
  class Forearm	 *forearm_r, *forearm_l;
  class Arm	 *arm_r, *arm_l;
  class Shoulder *shoulders[2];
  class Neck	 *neck;
  class Head	 *head;
  class Bust	 *bust;
  class Leg	 *legs[2];
  class Calf	 *calf_r, *calf_l;
  class Foot	 *foot_r, *foot_l;

  GLfloat tx,ty,tz,rx,ry,rz;

  struct VnpModel head1, neck1, body_up, body_bot;
  struct VnpModel la_up, la_mid, la_hand;
  struct VnpModel ra_up, ra_mid, ra_hand;
  struct VnpModel ll_up, ll_mid, ll_foot;
  struct VnpModel rl_up, rl_mid, rl_foot;
  GLuint manlist;
  
  char line[VAPS_BUFSIZ];
  int mask[NUM_BAPS_V32 + 1];
  int bap[NUM_BAPS_V32 + 1];
  int fap[NUM_FAPS + 1];
  
  char vaps[64];	///< bap server
  char faces_url[64];	///< faces url
  int sdtcp;
  int sdudp;
  struct sockaddr_in tcpsa;
  struct sockaddr_in udpsa;
  struct ip_mreq mreq;
  int ipmode;		///< IP mode
  int num_baps;		///< number of bap
  uint16_t bap_port;	///< server port
  struct _jp jp;	///< jointpoints

  class Face * faceObject;	// YR

  static const WClass wclass;	///< class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Android(char *l);
  /**< Constructor */

  static WObject * (creator)(char *l);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();

  virtual void createBody();
  /**< Creates body and joint points */

  virtual void loadUrlModels(int numjoints, class Http *http);
  /**< Loads body's parts */

  virtual void buildModel();
  /**< Builds body's parts in displaylists */

  virtual void manDisplay();
  /**< Displays body and face */

  virtual int connectToBapServer(int _ipmode);
  /**< Establishes a TCP connection to the bap server
   * and send the setup packet.
   * Sets sdtcp; return 1 if OK else return 0 if failed
   */

  virtual int initReceiver();
  /**< Inits listening */

  virtual int readBapFrame();
  /**< Gets a frame from the bap server */

  virtual void sendPlayToBapServer(const char *bap_name);
  /**< Sends a play command to the bap server */

  virtual void disconnectFromBapServer();
  /**< Closes connection with the bap server */
};

void ANDROID_INIT(void);

#endif // ANDROID_H
