#ifndef AOI_H
#define AOI_H

#define AOI_TYPE        18
#define AOI_NAME        "Aoi"
#define AOI_INIT	NULL

#define AOI_VISIBLE	// if hard debugging time

/**
 * Aoi Class
 * Area of Interest
 */
class Aoi: public WObject {
 public:

  char chan[CHAN_LEN];
  ///< aoi mcast channel string

  static const WClass wclass;
  ///< class variable

  virtual const WClass* getWClass() {return &wclass;};

  Aoi(char *l);

  static WObject * (creator)(char *l);

  virtual void aoiEnter();
  /**<
   * Performs action to be done while entering a new Area of Interest:
   *  - leaving previous one with aoiQuit() call
   *  - initializing the network on new AoI's mcast chan_str
   *  - initializing the only mobile object we know for now in
   *      this AoI: local user's avatar
   *
   * Unique caller is generalIntersect() (col.cc)
   */

  static void aoiQuit();
  /**<
   * Performs actions to be done while leaving an Area of Interest:
   *  - Remove all mobile object from network (leaving only static ones)
   *  - Shutdown the network
   *
   * Unique caller is aoiEnter() ... (see code aoi.cc)
   */

};

extern Aoi *currentAoi;	// points to current AoI local user is in

#endif // AOI_H
