#ifndef BALL_H
#define BALL_H

#define BALL_TYPE	5
#define BALL_NAME	"Ball"
#define BALL_INIT	ballInitFuncList
#define BALL_LASTING	0.03	/* 30 ms */
#define BALL_PROPS	4

#define BALL_PROPHNAME	0
#define BALL_PROPXY	1
#define BALL_PROPZ	2
#define BALL_PROPAZ	3

#define BALL_RADIUS	0.1	// 10 cm
#define BALL_LSPEED	5.0	// 5 m/s
#define BALL_ZSPEED	3.0	// 3 m/s
#define BALL_ASPEED	-1.5	// 1.5 rd/s
#define BALL_TTL	3.0	// 3 s
#define BALL_DELTAZ	0.02	// 2 cm
#define BALL_SHIFTX	1.0	// 1 m
#define BALL_SHIFTY	1.0	// 1 m
#define BALL_ORIGZ	1.0	// 1 m
#define BALL_COLOR	"1,1,0"	// yellow
#define BALL_DENSITY	0.1

/* actions */
#define BALL_PUSH	0
#define BALL_PULL	1
#define BALL_SHOOT	2
#define BALL_UP		3
#define BALL_TAKE	4
#define BALL_DROP	5
#define BALL_TURN	6
#define BALL_KILL	7
#define BALL_CREAT	8

#if 0 //Mac0S-10.2.6
extern "C" {
extern double drand48();	// MacOSX
}
#endif

/**
 * Ball Class
 */
class Ball: public WObject {

 public:
  float lspeed;		///< linear speed in xy
  float aspeed;		///< angular speed
  float zspeed;		///< linear speed in z
  float ttl;		///< time to live
  float origz;		///< position at creation
  bool taken;		///< taken or not by an user

  static const WClass wclass; ///< class variable
  static const uint8_t props;

  virtual const WClass* getWClass() {return &wclass;};

  Ball(WObject *po, void *data, time_t s, time_t us);
  /**< constructor: called by cauldron */

  Ball(uint8_t type_id, NetObjectId noid, Payload *pp);
  /**< constructor: network replication */

  void setDefaults();
  /**< ball defaults */

  static WObject * replicator(uint8_t type_id, NetObjectId noid, Payload *pp);
  /**< Replicates a ball coming from the Network */

  virtual bool isMoving();
  /**< Checks if object is moving */

  virtual void changePosition(float lasting);
  /**< Does any position changes */

  virtual void changePermanent(float lasting);
  /**< Does permanent position changes */

  virtual void updateTime(time_t, time_t, float *);
  /**< Updates times */

  virtual bool updateToNetwork(const Pos &oldpos);
  /**< Publishes to network */

  virtual void whenIntersect(WObject *pcur, WObject *pold);
  /**< Handles collisions */

};

void BALL_INIT(void);

#endif // BALL_H
