#include "global.h"
#include "wo.h"
#include "world.h"	// worlds
#include "bgcolor.h"

#include "vgl.h"	// bgcolor


const WClass Bgcolor::wclass(BGCOLOR_TYPE, "Bgcolor", Bgcolor::creator);
void bgcolorInitFuncList(void) {}

// static class member initialization
Bgcolor * Bgcolor::bgcolor = NULL;

WObject * Bgcolor::creator(char *l)
{
  return new Bgcolor(l);
}

Bgcolor::Bgcolor(char *l)
{
  if (bgcolor) {
    warning("You can't have more than one bgcolor per world");
    return;
  }

  l = parseObject(l);
  l = parseColor(l);

  /* we use (x,y,z,az) to match (r,g,b,a) */
  worlds->bgcolor->r = r = pos.x;
  worlds->bgcolor->g = g = pos.y;
  worlds->bgcolor->b = b = pos.z;
  worlds->bgcolor->a = a = pos.az;

  initializeObject(LIST_INVISIBLE);
  bgcolor = this;
} 

Bgcolor::Bgcolor()
{
  black();
} 

void Bgcolor::black()
{
  r = g = b = a = 0;
}

void Bgcolor::quit()
{
  black();
  bgcolor = NULL;
}
