#include "global.h"
#include "wo.h"
#include "world.h"
#include "board.h"

#include "app.h"	// startwhiteboard
#include "texture.h"	// TextureCacheEntry::getCurrentNumber


const WClass Board::wclass(BOARD_TYPE, "Board", Board::creator);


/* creation from a file */
WObject * Board::creator(char *l)
{
  return new Board(l);
}

Board::Board(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  initializeObject(LIST_STILL);
  trace(DBG_WO, "Board: texture_num=%d", TextureCacheEntry::getCurrentNumber());
  status = BOARD_INACTIVE;
} 

/* object intersect: projection */
void Board::whenIntersect(WObject *pcur, WObject *pold)
{
  if (projectMovementOnObject(pcur->pos, pold->pos, pos))
    pcur->updateObject(pold->pos);
  else
    pold->copyPositionAndBB(pcur);
}

void boardDraw(Board *po, void *d, time_t s, time_t u)
{
  App::quitwhiteboard();
  App::startwhiteboard(World::getChannelName());
  po->status = BOARD_OPEN;
}

void boardImport(Board *po, void *d, time_t s, time_t u)
{
  if (po->status == BOARD_INACTIVE)
    return;
  po->status |= BOARD_IMPORT;
  notice("Click in the whiteboard window");
  /* TODO */
}

void boardExit(Board *po, void *d, time_t s, time_t u)
{
  App::quitwhiteboard();
}

void Board::quit()
{
  App::quitwhiteboard();
}

void boardInitFuncList(void)
{
  setActionFunc(BOARD_TYPE, 0, WO_ACTION boardDraw, "Draw");
  setActionFunc(BOARD_TYPE, 1, WO_ACTION boardImport, "Import");
  setActionFunc(BOARD_TYPE, 2, WO_ACTION boardExit, "Exit");
}
