#ifndef BULLET_H
#define BULLET_H

#define BULLET_TYPE	15
#define BULLET_NAME	"Bullet"
#define	BULLET_INIT	bulletInitFuncList
#define BULLET_LASTING	0.03	/* 30 ms */
#define BULLET_PROPS	5

#define BULLET_PROPHNAME	0
#define BULLET_PROPXY		1
#define BULLET_PROPZ		2
#define BULLET_PROPAZ		3
#define BULLET_PROPHIT		4

#define BULLET_SPEED		5.0	// 5 m/s
#define BULLET_TTL		3.0	// 3 s
#define BULLET_DELTAZ		0.05	// 5 cm

/* bullet geometry */
#define BULLET_RADIUS		0.01	// 1 cm
#define BULLET_COLOR		"1,0,0"	// red

/* actions */
#define BULLET_CREAT		0

/**
 * Bullet Class
 */
class Bullet: public WObject {
 public:
  float lspeed;		// linear speed
  uint8_t hit;		// hit: no=0, yes=1

  static const WClass wclass;	// class variable
  static const uint8_t props;

  virtual const WClass* getWClass() {return &wclass;};

  Bullet(WObject *, void *, time_t, time_t);
  Bullet(uint8_t type_id, NetObjectId noid, Payload *);

  static WObject * replicator(uint8_t type_id, NetObjectId noid, Payload *pp);

  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void whenWallIntersect(WObject *pold, V3 *norm);
};

void BULLET_INIT(void);

#endif // BULLET_H
