#include "global.h"
#include "wo.h"
#include "names.h"	// getObjectByName
#include "button.h"

#include "net.h"	// NetObject
#include "vgl.h"	// setSolidFrame


const WClass Button::wclass(BUTTON_TYPE, "Button", Button::creator);
const uint8_t Button::props = BUTTON_PROPS;

static uint16_t oid = 0;


WObject * Button::creator(char *l)
{
  return new Button(l);
}

Button::Button(char *l)
{
  method0 = method1 = 0;

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  refname = new char[OBJNAME_LEN];

  while (l) {
   if (!strncmp(l, "refname", 7))
      l = parseString(l, refname, "refname");
   else if (!strncmp(l, "state", 5))
      l = parseUInt8(l, &pos.state, "state");
   else if (!strncmp(l, "method0", 7))
      l = parseUInt8(l, &method0, "method0");
   else if (!strncmp(l, "method1", 7))
      l = parseUInt8(l, &method1, "method1");
  }

  enableBehavior(COLLIDE_NEVER);
  initializeObject(LIST_MOBILE);
  setMaxLasting(BUTTON_LASTING);
  createPermanentNetObject(props, ++oid);
} 

/* Updates towards the network */
bool Button::updateToNetwork(const Pos &oldpos)
{
  bool change = false;

  if (pos.state != oldpos.state) {
    noh->declareObjDelta(BUTTON_PROPSTATE);
    change = true;
  }
  return change;
}

void buttonSwitch(Button *po, void *d, time_t s, time_t us)
{
  int method;
  
  if (po->pos.state == 0)
    method = po->method0;
  else
    method = po->method1;
  po->pos.state = 1 - po->pos.state;
  po->soh->setSolidFrame(po->pos.state);

  WObject *psel = NULL;

  if ((psel = getObjectByName(po->refname)) != NULL) {
    if ((method <= OBJECTSNUMBER) &&
	(generalActionList[method][psel->type].method != NULL))
#if 0
      generalActionList[method][psel->type].po->method(d, s, us);
#else
      generalActionList[method][psel->type].method(psel, d, s, us);
#endif
    else
      warning("buttonSwitch: object named %s has no method %d",
	      po->refname, method);
  }
  else
    warning("button: no object named %s", po->refname);
}

void Button::updateTime(time_t s, time_t us, float *lasting)
{
  *lasting = 0.;
}

void get_bstate(Button *po, Payload *pp)
{
  Pos oldpos = po->pos;
  
  pp->getPayload("d", &(po->pos.state));
  po->updateObject(oldpos);
}

void put_bstate(Button *po, Payload *pp)
{
  pp->putPayload("d", po->pos.state);
}

void Button::quit()
{
  if (refname)
    delete[] refname;
  refname = NULL;
  oid = 0;
}

void buttonInitFuncList(void)
{
  getPropertyFunc[BUTTON_PROPSTATE][BUTTON_TYPE].pf = WO_PAYLOAD get_bstate;
  putPropertyFunc[BUTTON_PROPSTATE][BUTTON_TYPE].pf = WO_PAYLOAD put_bstate;

  setActionFunc(BUTTON_TYPE, 0, WO_ACTION buttonSwitch, "Push");
}
