#ifndef CART_H
#define CART_H
 
#define CART_TYPE	42
#define CART_NAME	"Cart"
#define	CART_INIT	cartInitFuncList

// target values handled by GuiRemoveCartItem in gui.cc
#define CART_REMOVE	0
#define CART_DROP	1

/**
 * Cart Class
 */
class Cart: public WObject {
 private:
  ObjectList *cartList;
 
 public:
  Cart(char *l);
  /**< constructor */

  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};

  virtual void addObjectToCart(WObject *po);
  /**< called by thingAddToCart */

  virtual void removeObjectFromCart(WObject *po);
  /**< called by GuiRemoveCartItem (target = "CART_REMOVE") */

  virtual void dropObjectIntoWorld(WObject *po);
  /**< called by GuiRemoveCartItem (target = "CART_DROP") */
  
};

void CART_INIT(void);

#endif // CART_H
