#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "ball.h"	// BALL_TYPE
#include "water.h"	// WATER_TYPE
#include "move.h"	// GRAVITY
#include "caul.h"


const WClass Cauldron::wclass(CAULDRON_TYPE, "Cauldron", Cauldron::creator);


/* creation from a file */
WObject * Cauldron::creator(char *l)
{
  return new Cauldron(l);
}

Cauldron::Cauldron(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  initializeObject(LIST_MOBILE);
  setMaxLasting(MAXFLOAT);
  enablePermanentMovement();
} 

/* Creates a ball */
void cauldronCreateBall(Cauldron *po, void *data, time_t sec, time_t usec)
{
  if (generalActionList[BALL_CREAT][BALL_TYPE].method)
    generalActionList[BALL_CREAT][BALL_TYPE].method(po, data, sec, usec);
}

void Cauldron::changePermanent(float lasting)
{
  pos.z -= lasting * GRAVITY / 2;
}

void Cauldron::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
    pcur->pos.z += CAULDRON_DELTAZ;
    break;
  case BALL_TYPE:
    srand((uint32_t) time(NULL));
    // FIXME
    pcur->pos.x += ((float) drand48() * 2 -1) * BALL_RADIUS / 2;
    pcur->pos.y += ((float) drand48() * 2 -1) * BALL_RADIUS / 2;
    break;
  default:
    //pd pcur->pos.z -= pos.bbsize.v[2] / 10;
    pold->copyPositionAndBB(pcur);
    return;
  }
  pcur->update3D();
  pcur->getBB();
}

void cauldronInitFuncList(void)
{
  setActionFunc(CAULDRON_TYPE, 0, WO_ACTION cauldronCreateBall, "Ball");
}
