#include "global.h"
#include "wo.h"
#include "world.h"
#include "clip.h"

#include "net.h"	// getGroup
#include "app.h"	// startmpg


const WClass Clip::wclass(CLIP_TYPE, "Clip", Clip::creator);


WObject * Clip::creator(char *l)
{
  return new Clip(l);
}

Clip::Clip(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);

  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_STILL);

  char *purl, *ptmpurl;

  purl = strrchr(name.url, '.');
  purl++;
  if (!strncmp(purl, "mpg", 3) || !strncmp(purl, "mpeg", 4)) {
    fmt = CLIP_FMT_MPEG;
  }
  else if (!strncmp(purl, "video", 5)) {
    fmt = CLIP_FMT_RTPAV;
    strcpy(url2, name.url);
    ptmpurl = strrchr(url2, '.');
    *(++ptmpurl) = '\0';
    strcpy(ptmpurl, "audio");
  }
  else if (!strncmp(purl, "audio", 5)) {
    fmt = CLIP_FMT_RTPAV;
    strcpy(url2, name.url);
    ptmpurl = strrchr(name.url, '.');
    *(++ptmpurl) = '\0';
    strcpy(ptmpurl, "video");
  }
  else
    error("Clip: unknown media format");
  status = CLIP_RTP_INACTIVE;
} 

void Clip::whenIntersect(WObject *pcur, WObject *pold)
{
  pold->copyPositionAndBB(pcur);
}

void postCgi(const char *cmd)
{
  App::startwget(cmd, NULL);
}

void Clip::startRtp()
{
  if (status == CLIP_RTP_ACTIVE)
    return;	// busy

  char *pfile, *end;
  pfile = strrchr(name.url, '/');
  pfile++;
  end = strchr(pfile, '.');
  *end = '\0';

  char group[GROUP_LEN];
  getGroup(World::getChannelName(), group);

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s&%s&%d&%d", CLIP_RTP_URL, CLIP_PLAY_CGI,
          pfile,
          group,
          getPort(World::getChannelName()) + 2,
          currentTtl());
  postCgi(cmd);
  status = CLIP_RTP_ACTIVE;
}

void Clip::stopRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;	// nothing

  char group[GROUP_LEN];
  getGroup(World::getChannelName(), group);

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_STOP_CGI,
          group,
          getPort(World::getChannelName()) + 2,
          currentTtl(),
          group,
          getPort(World::getChannelName()) + 4,
          currentTtl()
         );
  postCgi(cmd);
  status = CLIP_RTP_INACTIVE;
}

void Clip::pauseRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;

  char group[GROUP_LEN];
  getGroup(World::getChannelName(), group);

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_PAUSE_CGI,
          group,
          getPort(World::getChannelName()) + 2,
          currentTtl(),
          group,
          getPort(World::getChannelName()) + 4,
          currentTtl()
         );
  postCgi(cmd);
}

void Clip::contRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;

  char group[GROUP_LEN];
  getGroup(World::getChannelName(), group);

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_CONT_CGI,
          group,
          getPort(World::getChannelName()) + 2,
          currentTtl(),
          group,
          getPort(World::getChannelName()) + 4,
          currentTtl()
         );
  postCgi(cmd);
}

void clipStart(Clip *po, void *d, time_t s, time_t u)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    App::startmpg(po->name.url);
    break;
  case CLIP_FMT_RTPAV:
    App::startvideo(World::getChannelName());
    App::startaudio(World::getChannelName());
    po->startRtp();
    break;
  default:
    break;
  }
}

void clipStop(Clip *po, void *d, time_t s, time_t u)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    App::stopmpg();
    break;
  case CLIP_FMT_RTPAV:
    App::quitvideo();
    App::quitaudio();
    po->stopRtp();
    break;
  default:
    break;
  }
}

void clipPause(Clip *po, void *d, time_t s, time_t u)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    App::pausempg();
    break;
  case CLIP_FMT_RTPAV:
    po->pauseRtp();
    break;
  default:
    break;
  }
}

void clipCont(Clip *po, void *d, time_t s, time_t u)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    App::contmpg();
    break;
  case CLIP_FMT_RTPAV:
    po->contRtp();
    break;
  default:
    break;
  }
}

void Clip::quit()
{
  status = CLIP_RTP_INACTIVE;
  stopRtp();
  App::stopmpg();
}

void clipInitFuncList(void)
{
  setActionFunc(CLIP_TYPE, 0, WO_ACTION clipStart, "Play");
  setActionFunc(CLIP_TYPE, 1, WO_ACTION clipStop, "Stop");
  setActionFunc(CLIP_TYPE, 2, WO_ACTION clipPause, "Pause");
  setActionFunc(CLIP_TYPE, 3, WO_ACTION clipCont, "Continue");
}
