#ifndef CLIP_H
#define CLIP_H

#define CLIP_TYPE	26
#define CLIP_NAME	"Clip"
#define	CLIP_INIT	clipInitFuncList

#define CLIP_FMT_MPEG	1
#define CLIP_FMT_RTPAV	2
#define CLIP_FMT_MPEG4	3
#define CLIP_FMT_FLASH	4

#define CLIP_RTP_INACTIVE 0
#define CLIP_RTP_ACTIVE	1
#define CLIP_RTP_URL	"http://horla.enst.fr:8080/~dax/services/avod/"
#define CLIP_PLAY_CGI	"rtpplay.cgi"
#define CLIP_STOP_CGI	"rtpstop.cgi"
#define CLIP_PAUSE_CGI	"rtppause.cgi"
#define CLIP_CONT_CGI	"rtpcont.cgi"

/**
 * Clip Class
 */
class Clip: public WObject {
 public:
  uint8_t fmt;
  uint8_t status;
  char url2[URL_LEN];

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Clip(char *l);

  static WObject * (creator)(char *l);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();

  virtual void startRtp();
  virtual void pauseRtp();
  virtual void contRtp();
  virtual void stopRtp();
};

void CLIP_INIT(void);

#endif // CLIP_H
