#include "global.h"
#include "wo.h"
#include "clock.h"


const WClass Clock::wclass(CLOCK_TYPE, "Clock", Clock::creator);
const uint8_t Clock::props = CLOCK_PROPS;

void clockInitFuncList(void) {}

static uint16_t oid = 1;


void Clock::init()
{
  time_t t = time(0);
  struct tm *pdate = localtime(&t);
  sec = pdate->tm_sec;
  min = pdate->tm_min;
  hour = pdate->tm_hour;
  sec_last = min_last = hour_last = 255;

  enablePermanentMovement();
  changePermanent(0.);
}

void Clock::updateTime(time_t s, time_t us, float *lasting)
{
  struct tm *pdate = localtime(&s);

  sec = pdate->tm_sec;
  min = pdate->tm_min;
  hour = pdate->tm_hour;
  yday = pdate->tm_yday;
}

void Clock::changePermanent(float lasting)
{
  switch (needle % 3) {
    case CLOCK_SECOND:	// secondes
      pos.ax = ((float) sec * M_PI / 30) + M_PI_2;
      //trace(DBG_WO, "sec=%d %f obj=%d", sec, pos.ax, needle);
      break;
    case CLOCK_MINUTE:	// minutes
      if (min != min_last) {
        pos.ax = ((float) min * M_PI / 30) + M_PI_2;
        min_last = min;
      }
      break;
    case CLOCK_HOUR:	// hours
      if (hour != hour_last) {
        pos.ax = ((float) hour * M_PI / 6) +
                 ((float) min * M_PI / 360) + M_PI_2;
        //trace(DBG_WO, "hour=%d %f", hour % 12, pos.ax);
        hour_last = hour;
      }
      break;
  }
  sec_last = sec;
  daytime = 12 - 4 * Cos(360 * (float) yday/365.);
  risetime = 13 - daytime/2;
  falltime = 13 + daytime/2;
}

/** creation from a file */
WObject * Clock::creator(char *l)
{
  return new Clock(l);
}

/** External clock */
Clock::Clock(char *l)
{
  bool haveneedle = false;

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  while (l) {
    char needlestr[8] = "";
    if (!strncmp(l, "needle", 6)) {
      l = parseString(l, needlestr, "needle");
      haveneedle = true;
      switch (*needlestr) {
      case 's':
        needle = CLOCK_SECOND;
        break;
      case 'm':
        needle = CLOCK_MINUTE;
        break;
      case 'h':
        needle = CLOCK_HOUR;
        break;
      default:
        haveneedle = false;
      }
    }
  }

  enableBehavior(NO_ELEMENTARY_MOVE);
  enableBehavior(NO_BBABLE);
  enableBehavior(COLLIDE_NEVER);
  initializeObject(LIST_MOBILE);

  if (! haveneedle)
    needle = oid;
  init();
  trace(DBG_WO, "Clock: needle=%d name=%s", needle, name.instance_name);
  oid++;
}

/** Internal clock */
Clock::Clock()
{
  enableBehavior(NO_ELEMENTARY_MOVE);
  enableBehavior(NO_BBABLE);
  enableBehavior(COLLIDE_NEVER);
  enableBehavior(NO_SELECTABLE);
  enableBehavior(INVISIBLE);
  initializeObject(LIST_MOBILE);

  needle = CLOCK_SECOND;
  init();
}

bool Clock::isMoving()
{
  return true;
}

void Clock::quit()
{
  oid = 0;
}
