#include "global.h"
#include "wo.h"
#include "world.h"
#include "aoi.h"	// AOI_TYPE
#include "walls.h"	// wallsIntersectObject

#include "vgl.h"	// Solid


/* Returns a constant to describe intersection status of both Bounding Boxes */
static
int interBBs(V3 center1, V3 size1, V3 center2, V3 size2)
{
  float dcx = ABSF(center2.v[0] - center1.v[0]);
  float dcy = ABSF(center2.v[1] - center1.v[1]);
  float dcz = ABSF(center2.v[2] - center1.v[2]);
  float sx1 = ABSF(size1.v[0]);
  float sx2 = ABSF(size2.v[0]);
  float sy1 = ABSF(size1.v[1]);
  float sy2 = ABSF(size2.v[1]);
  float sz1 = ABSF(size1.v[2]);
  float sz2 = ABSF(size2.v[2]);
  
  if (dcx >= sx1 + sx2  ||  dcy >= sy1 + sy2  ||  dcz >= sz1 + sz2)
    return INTER_NO;	// doesn't intersect

  if (dcx + sx1 <= sx2  &&  dcy + sy1 <= sy2  && dcz + sz1 <= sz2)
    return INTER_1IN2;
  if (dcx + sx2 <= sx1  &&  dcy + sy2 <= sy1  &&  dcz + sz2 <= sz1)
    return INTER_2IN1;
  return INTER_INTERSECT;
}

/*
 * General function to handle intersections
 */
void WObject::generalIntersect(WObject *pold, ObjectList *vicinity)
{
  /* walls */
  V3 norm;
  if (wallsIntersectObject(&pos.bbcenter, &pos.bbsize, &norm)) {
    whenWallIntersect(pold, &norm);
  }
 
  bool ya_collision = false;

  for (ObjectList *pl = vicinity; pl && pl->pobject ; ) {
    WObject *po = pl->pobject;

    if (! po->isValid()) {	// SURELY a BUG!
      pl = pl->next;
      error("generalIntersect: po NULL");
      continue;
    }
    if (po->isBehavior(COLLIDE_NEVER) || po->isBehavior(NO_BBABLE)) {
      pl = pl->next;
      continue;
    }

    /* MS: Test for outgoing intersection */
    if (interBBs(pos.bbcenter, pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) == INTER_NO &&
        interBBs(pold->pos.bbcenter, pold->pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) != INTER_NO) {
      if (po->whenIntersectOut(this, pold)) {
        if (World::isDead()) return;
        switch (po->collideBehavior()) {
          case COLLIDE_ONCE:
          case COLLIDE_GHOST:
            pl = pl->next;
            break;
          default:
            pl = vicinity;
            break;
        }
      }
      else
        pl = pl->next;
      continue;
    }

    /* MS: Test for ingoing intersection */
    else if (interBBs(pos.bbcenter, pos.bbsize,
                      po->pos.bbcenter, po->pos.bbsize) != INTER_NO &&
             interBBs(pold->pos.bbcenter, pold->pos.bbsize,
                      po->pos.bbcenter, po->pos.bbsize) == INTER_NO) {
        ya_collision = true;

      /* current object intersects and its old instance didn't intersect */
      if (po->type != AOI_TYPE) {
        po->whenIntersect(this, pold);
        if (World::isDead()) return;
        switch (po->collideBehavior()) {
          case COLLIDE_ONCE:
          case COLLIDE_GHOST:
            pl = pl->next;
            break;
          default:
            if (isBehavior(COLLIDE_GHOST) || isBehavior(COLLIDE_ONCE))
              pl = pl->next;
            else
              pl = vicinity;
        }
        continue;
      }

      // begin AOI
      else {
        /* 2 cases: local avatar or another mobile object */
        if (this == (WObject *) worlds->plocaluser) {
          if (currentAoi != po) {
            Aoi *aoi = (Aoi *) po;
            aoi->aoiEnter();	// avatars: change mcast address
          }
        }
        else {	// other mobile objects: problem of property transfert
		  ;
        }
        break;	// avoids a warning
      }
      // end AOI
    }
#if 0 //pd
    else if (! World::isDead()) {
      po->whenNoIntersect(this, pold);
    }
#endif //pd
    pl = pl->next;
  }
  if (! ya_collision)
    state.collide = 0;
}

/* Returns normale vectors 'norm' of still object */
static
void normale(Pos &mobile, Pos &fixe, V3 *norm)
{
  float fxmin = fixe.bbcenter.v[0] - fixe.bbsize.v[0];
  float fxmax = fixe.bbcenter.v[0] + fixe.bbsize.v[0];
  float fymin = fixe.bbcenter.v[1] - fixe.bbsize.v[1];
  float fymax = fixe.bbcenter.v[1] + fixe.bbsize.v[1];
  //pd float mxmin = mobile.bbcenter.v[0] - mobile.bbsize.v[0];
  //pd float mxmax = mobile.bbcenter.v[0] + mobile.bbsize.v[0];
  //pd float mymin = mobile.bbcenter.v[1] - mobile.bbsize.v[1];
  //pd float mymax = mobile.bbcenter.v[1] + mobile.bbsize.v[1];

  V3 n;
  n.v[2] = 0;
  if (fxmax - fxmin < fymax - fymin) {
    n.v[0] = 1;
    n.v[1] = 0;
  } else {
    n.v[0] = 0;
    n.v[1] = 1;
  }
  /* test which normale we take, computes dotprod */
  float dp = (mobile.bbcenter.v[0] - fixe.bbcenter.v[0]) * n.v[0]
           + (mobile.bbcenter.v[1] - fixe.bbcenter.v[1]) * n.v[1]
           + (mobile.bbcenter.v[2] - fixe.bbcenter.v[2]) * n.v[2];
  if (dp < 0) {
    n.v[0] = -n.v[0];
    n.v[1] = -n.v[1];
  }
  *norm = n;
}

/* Projete le mouvement de l'objet mobile parallelement a l'objet fixe */
int projectMovementOnObject(Pos &mobile, Pos &mobileold, Pos &fixe)
{
  float dx = mobile.x - mobileold.x;
  float dy = mobile.y - mobileold.y;
  float dz = mobile.z - mobileold.z;

  if ((ABSF(dx) + ABSF(dy) + ABSF(dz)) == 0)
    return 0;	// nothing to do

  V3 n;
  normale(mobile, fixe, &n);

  float nx = n.v[0];
  float ny = n.v[1];
  float nz = n.v[2];
  float dp = nx*dx + ny*dy + nz*dz;	// dotprod

  if (dx)
    mobile.x += -(dp*nx);
  if (dy)
    mobile.y += -(dp*ny);
  if (dz)
    mobile.z += -(dp*nz);

  if (dp > 0)
    return 1;
  if (dp < 0)
    return -1;
  return 0;
}

/* we do not change the position, we only change the deltas */
void WObject::wallIntersect(WObject *pold, V3 *norm)
{
  pold->copyPositionAndBB(this);

  float nx = norm->v[0];
  float ny = norm->v[1];
  float dx = move.lspeed.v[0];
  float dy = move.lspeed.v[1];

  float nn = sqrt(dx*dx + dy*dy);
  if (nn == 0)
    return;
  float dxn = dx / nn;
  float dyn = dy / nn;
  float dotprod = dxn * nx + dyn * ny;
  if (dotprod >= 0)
    return;

  move.lspeed.v[0] = (dxn - 2 * dotprod * nx) * nn;
  move.lspeed.v[1] = (dyn - 2 * dotprod * ny) * nn;
}
