#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "dart.h"

#include "net.h"
#include "app.h"	// playSound


const WClass Dart::wclass(DART_TYPE, "Dart", NULL, Dart::replicator);
const uint8_t Dart::props = DART_PROPS;


void Dart::updateTime(time_t sec, time_t usec, float *lasting)
{
  if (move.sec == 0) {
    *lasting = move.ttl -= DART_LASTING;
    move.sec = sec;
    move.usec = usec;
    return;
  }

  *lasting = diffTime(sec, usec);
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    stopImposedMovement();

    /* the dart has spent its time to live => destroyed */
    //notice("%s destroyed", name.instance_name);
    toDelete();	// delete Wobject
  }
}

void Dart::changePosition(float lasting)
{
  pos.x += lasting * move.lspeed.v[0];
  pos.y += lasting * move.lspeed.v[1];
  pos.z += lasting * move.lspeed.v[2];
}

bool Dart::isMoving()
{
  return (move.ttl > 0.0005);
}

Dart::Dart(WObject *pu, void *data, time_t sec, time_t usec)
{
  /* position */
  pos.x = pu->pos.x;	//BAD + move.lspeed.v[0] * 0.2;
  pos.y = pu->pos.y;	//BAD + move.lspeed.v[1] * 0.2;
  pos.z = pu->pos.z + 0.3 * USER_DEFAULTHEIGHT;
  pos.az = pu->pos.az;

  /* geometry */
  char geom[80];
  sprintf(geom,"solid=\"box,size=%s,emission=%s\"", DART_GEOMETRY, DART_COLOR);
  parseGeometry(geom);

  /* local creation */
  type = DART_TYPE;
  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_MOBILE);
  setMaxLasting(DART_LASTING);
  lspeed = DART_SPEED;

  /* network creation */
  createVolatileNetObject(props);
  noh->declareObjCreation();

  /* action */
  move.lspeed.v[0] = lspeed * Cos(pu->pos.az);
  move.lspeed.v[1] = lspeed * Sin(pu->pos.az);
  enablePermanentMovement();
  initImposedMovement(DART_TTL);
}

/* Creation: this method is invisible, called by user */
void dartCreateByUser(User *pu, void *data, time_t sec, time_t usec)
{
  new Dart(pu, data, sec, usec);
  App::playSound(SHOOTSND);
}

/* Replication from the network */
WObject * Dart::replicator(uint8_t type_id, NetObjectId noid, Payload *pp)
{
  return new Dart(type_id, noid, pp);
}

Dart::Dart(uint8_t type_id, NetObjectId _noid, Payload *pp)
{
  setType(type_id);

  replicateVolatileNetObject(props, _noid);
  noh->getAllProperties(pp);
  copyNetObjectId(_noid);

  char geom[128];
  sprintf(geom, "solid=\"box,size=%s,emission=%s\"", DART_GEOMETRY, DART_COLOR);
  parseGeometry(geom);

  initializeObject(LIST_MOBILE);
  lspeed = DART_SPEED;
  initBB(pos);

  //pd initImposedMovement(DART_TTL);

  App::playSound(SHOOTSND);
}

void get_hit(Dart *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;

  pp->getPayload("c", &(pcur->hit));
  // pp->dumpPayload(stdout);

  if (pcur->hit == 1) {
    pcur->hit = 0;
    notice("%s hits me", pcur->name.instance_name);
    App::playSound(OUILLESND);
  }
  pcur->updateObject(oldpos);
}

/* Updates to the network */
bool Dart::updateToNetwork(const Pos &oldpos)
{
  bool change = false;

  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    noh->declareObjDelta(DART_PROPXY);
    change = true;
  }
  if (ABSF(pos.z - oldpos.z) > DART_DELTAZ)
    change = true;
  if (pos.az != oldpos.az)
    change = true;
#if 0 //not used
  if (hit != pold->hit) {
    /* noh->declareObjDelta(DART_PROPHIT); */
    trace(DBG_FORCE, "dartUpdateToNetwork: curhit=%d oldhit=%d", hit, pold->hit);
    change = true;
  }
#endif
  return change;
}

void Dart::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
    /* dart intersects an user in movement: hit */
    notice("%s hit by %s", pcur->name.instance_name, name.instance_name);
    pold->copyPositionAndBB(pcur);
    break;
  default:
    pold->copyPositionAndBB(pcur);
  }
  toDelete();	// delete Wobject
}

void Dart::whenWallIntersect(WObject *pold, V3 *norm)
{
  enableBehavior(COLLIDE_ONCE);
  wallIntersect(pold, norm);
}

void dartInitFuncList(void)
{
  getPropertyFunc[DART_PROPXY][DART_TYPE].pf = WO_PAYLOAD get_xy;
  getPropertyFunc[DART_PROPZ][DART_TYPE].pf = WO_PAYLOAD get_z;
  getPropertyFunc[DART_PROPAZ][DART_TYPE].pf = WO_PAYLOAD get_az;
  getPropertyFunc[DART_PROPHNAME][DART_TYPE].pf = WO_PAYLOAD get_hname;
  getPropertyFunc[DART_PROPHIT][DART_TYPE].pf = WO_PAYLOAD get_hit;

  putPropertyFunc[DART_PROPXY][DART_TYPE].pf = WO_PAYLOAD put_xy;
  putPropertyFunc[DART_PROPZ][DART_TYPE].pf = WO_PAYLOAD put_z;
  putPropertyFunc[DART_PROPAZ][DART_TYPE].pf = WO_PAYLOAD put_az;
  putPropertyFunc[DART_PROPHNAME][DART_TYPE].pf = WO_PAYLOAD put_hname;
  putPropertyFunc[DART_PROPHIT][DART_TYPE].pf = WO_PAYLOAD dartPutHit; // user.c

  setActionFunc(DART_TYPE, 0, WO_ACTION dartCreateByUser, "");
}
