#include "global.h"
#include "wo.h"
#include "doc.h"

#include "app.h"	// startbrowser


const WClass Doc::wclass(DOC_TYPE, "Doc", Doc::creator);


/* creation from a file */
WObject * Doc::creator(char *l)
{
  return new Doc(l);
}

Doc::Doc(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);

  initializeObject(LIST_STILL);
} 

void Doc::whenIntersect(WObject *pcur, WObject *pold)
{
  pold->copyPositionAndBB(pcur);
}

void docView(Doc *po, void *d, time_t s, time_t u)
{
  App::viewps(po->name.url);
  //pd App::startbrowser(po->name.url);
}

void docPrint(Doc *po, void *d, time_t s, time_t u)
{
  App::printps(po->name.url);
}

void docClose(Doc *po, void *d, time_t s, time_t u)
{
  App::quitps();
}

void Doc::quit()
{
  App::quitps();
}

void docInitFuncList(void)
{
  setActionFunc(DOC_TYPE, 0, WO_ACTION docView, "View");
  setActionFunc(DOC_TYPE, 1, WO_ACTION docPrint, "Print");
  setActionFunc(DOC_TYPE, 2, WO_ACTION docClose, "Close");
}
