#include "global.h"
#include "wo.h"
#include "world.h"	// worlds
#include "user.h"
#include "entry.h"


const WClass Entry::wclass(ENTRY_TYPE, "Entry", Entry::creator);
void entryInitFuncList(void) {}

// static class member initialization
Entry * Entry::entry = NULL;

/* creation from a file */
WObject * Entry::creator(char *l)
{
  return new Entry(l);
}

Entry::Entry(char *l)
{
  if (entry) {
    warning("You can't have more than one entry per world");
    return;
  }

  l = parseObject(l);
  l = parsePosition(l);

  if (worlds->plocaluser->have_entry) {
    worlds->plocaluser->have_entry = false;
  }
  else {
    worlds->plocaluser->pos.x = pos.x;
    worlds->plocaluser->pos.y = pos.y;
    worlds->plocaluser->pos.az = pos.az;
  }

  initializeObject(LIST_INVISIBLE);
  //pd setEntry(this);
  entry = this;
} 

#if 0
/**
 * Returns the singleton instance
 */
Entry * Entry::getEntry()
{
  return entry;
}

/**
 * Sets the singleton instance
 */
void Entry::setEntry(Entry *_entry)
{
  entry = _entry;
}
#endif

void Entry::quit()
{
  //pd setEntry(NULL);
  entry = NULL;
}
