// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //
#ifndef FACE_H
#define FACE_H

#include <GL/gl.h>

#include "boneVect3d.h"		// The inline 3d vector class
#include "boneVert.h"		// The bone vertex class
#include "boneMesh3d.h"		// The mesh 3d class
#include "boneLink.h"		// The vertex/boneVertex link class
#include "boneAnimator.h"	// And the animator class
#include "boneFactory.h"	// Downloader

#define FACE_SCALE	0.075	// 3/400

// FAP names
#define VISEME			1
#define EXPRESSION		2
#define OPEN_JAW		3
#define LOWER_T_MIDLIP		4
#define RAISE_B_MIDLIP		5
#define STRETCH_L_CORNERLIP	6
#define STRETCH_R_CORNERLIP	7
#define LOWER_T_LIP_LM		8
#define LOWER_T_LIP_RM		9
#define RAISE_B_LIP_LM		10
#define RAISE_B_LIP_RM		11
#define RAISE_L_CORNERLIP	12
#define RAISE_R_CORNERLIP	13
#define THRUST_JAW		14
#define SHIFT_JAW		15
#define PUSH_B_LIP		16
#define PUSH_T_LIP		17
#define DEPRESS_CHIN		18
#define CLOSE_T_L_EYELID	19
#define CLOSE_T_R_EYELID	20
#define CLOSE_B_L_EYELID	21
#define CLOSE_B_R_EYELID	22
#define YAW_L_EYEBALL		23
#define YAW_R_EYEBALL		24
#define PITCH_L_EYEBALL		25
#define PITCH_R_EYEBALL		26
#define THRUST_L_EYEBALL	27
#define THRUST_R_EYEBALL	28
#define DILATE_L_PUPIL		29
#define DILATE_R_PUPIL		30
#define RAISE_L_I_EYEBROW	31
#define RAISE_R_I_EYEBROW	32
#define RAISE_L_M_EYEBROW	33
#define RAISE_R_M_EYEBROW	34
#define RAISE_L_O_EYEBROW	35
#define RAISE_R_O_EYEBROW	36
#define SQUEEZE_L_EYEBROW	37
#define SQUEEZE_R_EYEBROW	38
#define PUFF_L_CHEEK		39
#define PUFF_R_CHEEK		40
#define LIFT_L_CHEEK		41
#define LIFT_R_CHEEK		42
#define SHIFT_TONGUE_TIP	43
#define RAISE_TONGUE_TIP	44
#define THRUST_TONGUE_TIP	45
#define RAISE_TONGUE		46
#define TONGUE_ROLL		47
#define HEAD_PITCH		48
#define HEAD_YAW		49
#define HEAD_ROLL		50
#define LOWER_T_MIDLIP_O	51
#define RAISE_B_MIDLIP_O	52
#define STRETCH_L_CORNERLIP_O	53
#define STRETCH_R_CORNERLIP_O	54
#define LOWER_T_LIP_LM_O	55
#define LOWER_T_LIP_RM_O	56
#define RAISE_B_LIP_LM_O	57
#define RAISE_B_LIP_RM_O	58
#define RAISE_L_CORNERLIP_O	59
#define RAISE_R_CORNERLIP_O	60
#define STRETCH_L_NOSE		61
#define STRETCH_R_NOSE		62
#define RAISE_NOSE		63
#define BEND_NOSE		64
#define RAISE_L_EAR		65
#define RAISE_R_EAR		66
#define PULL_L_EAR		67
#define PULL_R_EAR		68

/**
 * Face Class
 */
class Face {
 public:
  LIST < char > urlList;

  int currentUrl;
  GLint textureId;

  bool moveYes;
  bool moveNo;
  bool moveMouth;
  bool moveSmile;
  bool moveSulk;
  bool moveEyeL;
  bool moveEyeR;
  bool moveNose;
  char cachefile[64];

  Mesh3D *mesh;
  BoneVertex *root;
  BoneAnimator animator;

  Face(const char *facesUrlIndex);
  //PD Face(char *faceFileName);
  virtual ~Face();

  virtual void render();
  virtual void animate();
  virtual void animate(int fapn, int value);
  virtual void changeFace();
  virtual void loadFace(const char *url);
  virtual void animEyeBall(float angle, const char *_side, int dir);
  virtual void animEyeLid(float angle, const char *root1, const char *root2, const char *left, const char *right);
  virtual void animEyeBrow(float angle, const char *_root, const char *_side);
  virtual void animLip(float angle, const char *_side);
  virtual void animNose(float angle, const char *_side);
  virtual void animHead(float angle, int x, int y, int z);
};

class Android;
void changeMoveYes(class Android *po, void *d, time_t s, time_t u);
void changeMoveNo(class Android *po, void *d, time_t s, time_t u);
void changeMoveMouth(class Android *po, void *d, time_t s, time_t u);
void changeMoveSmile(class Android *po, void *d, time_t s, time_t u);
void changeMoveSulk(class Android *po, void *d, time_t s, time_t u);
void changeMoveEyeR(class Android *po, void *d, time_t s, time_t u);
void changeMoveEyeL(class Android *po, void *d, time_t s, time_t u);
void changeMoveNose(class Android *po, void *d, time_t s, time_t u);
void changeFace(class Android *po, void *d, time_t s, time_t u);

#endif // FACE_H
