#ifndef GUY_H
#define GUY_H

#define GUY_TYPE 34
#define GUY_NAME "Guy"
#define	GUY_INIT guyInitFuncList


#define GUY_RATE 	10	// fps
#define GUY_CYCLE_SIZE	50	// orig = 100
#define GUY_CYCLE_STEP	(1.0/GUY_CYCLE_SIZE)
#define GUY_OVERSAMPLE	10
#define GUY_MAX_CPOINTS	34	// 2 end point ones and 10 in the middle
#define GUY_MAX_JOINTS	9
#define GUY_NUM_JOINTS	5

typedef struct ControlPts {
  int numpoints;
  float xcoords[GUY_MAX_CPOINTS];
  float angles[GUY_MAX_CPOINTS];
} tControlPts;

/**
 * Guy Class
 */
class Guy: public WObject {
 private:
  float incstep;	///< step increment
  uint8_t step;		///< position in cycle, start in middle
  int body_lists;	///< body displaylist
  float walk_cycle[2][GUY_MAX_JOINTS][GUY_CYCLE_SIZE]; ///< array of angles

 public:
  uint8_t anim;		///< anim toggle
  uint8_t walk;		///< walking toggle
  uint8_t accel;	///< acceleration toggle
  float rotx;
  float roty;
  float rotz;
  uint8_t numjoints;	///< joinpoint number
  tControlPts *curve;	///< series of ctrl points for a joint

  virtual void draw();
  virtual void draw_head();
  virtual void draw_torso();
  virtual void draw_uleg();
  virtual void draw_lleg();
  virtual void draw_foot();
  virtual void draw_uarm();
  virtual void draw_larm();
  virtual void display_head();
  virtual void display_torso();
  virtual void display_leg(int which);
  virtual void display_arm(int which);
  virtual void computeCurve(int joint);
  virtual void flatCSet();

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Guy(char *l);

  static WObject * (creator)(char *l);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();

};

void GUY_INIT(void);

#endif // GUY_H
