#ifndef ICON_H
#define ICON_H

#define ICON_TYPE	45
#define ICON_NAME	"Icon"
#define ICON_INIT	iconInitFuncList
#define ICON_LASTING	0.03	// 30 ms
#define ICON_PROPS	8

#define ICON_PROPHNAME	0
#define ICON_PROPXY	1
#define ICON_PROPZ	2
#define ICON_PROPAZ	3
#define ICON_PROPAX	4
#define ICON_PROPURL	5
#define ICON_PROPTEX	6
#define ICON_PROPGNAME	7

#define ICON_DEPTH	0.03	// x 3 cm
#define ICON_WIDTH	0.32	// y 32 cm
#define ICON_HEIGHT	0.32	// z 32 cm
#define ICON_LSPEED	1.0	// 1 m/s
#define ICON_ZSPEED	1.0	// 1 m/s
#define ICON_ASPEED	M_PI_4	// pi/4 /s
#define ICON_TTL	1.0	// 1 s
#define ICON_COLOR	"1,1,1"	// white

/* actions */
#define ICON_OPEN	0
#define ICON_SAVE	1
#define ICON_PIN	2
#define ICON_LEAVE	3
#define ICON_CARRY	4
#define ICON_KILL	5
#define ICON_PUSH	6
#define ICON_PULL	7
#define ICON_UP		8
#define ICON_DOWN	9
#define ICON_DROP	10
#define ICON_TURN	11
#define ICON_ROLL	12
#define ICON_CREAT	13
#define ICON_STICK	14
#if 0
#define ICON_LEFT	14
#define ICON_RIGHT	15
#endif


/**
 * Icon Class
 */
class Icon: public WObject {

 public:
  float lspeed;		///< linear speed in xy
  float aspeed;		///< angular speed
  float zspeed;		///< linear speed in z
  float ttl;		///< time to live
  bool taken;		///< taken or not by an user
  bool remove;		///< flag to remove
  char *tex;		///< texture of the icon
  char *ifile;		///< local input file
  char *ofile;		///< public output file
  char *vref;		///< vref entry to restore

  static const WClass wclass; ///< class variable
  static const uint8_t props;

  virtual const WClass* getWClass() {return &wclass;};

  Icon(class User *pu, void *data);
  /**< constructor: called by GUI */

  Icon(uint8_t type_id, NetObjectId noid, Payload *pp);
  /**< constructor: network replication */

  void setDefaults();
  /**< icon defaults */

  char * getParam(char *ptok);
  /**< gets parameter */

  static WObject * replicator(uint8_t type_id, NetObjectId noid, Payload *pp);
  /**< Replicates a icon coming from the Network */

  virtual bool isMoving();
  /**< Checks if object is moving */

  virtual void changePosition(float lasting);
  /**< Does any position changes */

  virtual void changePermanent(float lasting);
  /**< Does permanent position changes */

  virtual void updateTime(time_t, time_t, float *);
  /**< Updates times */

  virtual bool updateToNetwork(const Pos &oldpos);
  /**< Publishes to network */

  virtual void whenIntersect(WObject *pcur, WObject *pold);
  /**< Handles collisions */

  virtual void quit();
  /**< Quits */

};

void iconPin(class Icon *icon, void *d, time_t s, time_t u);
void iconPush(class Icon *icon, void *d, time_t s, time_t u);
void iconCarry(class Icon *icon, void *d, time_t s, time_t u);
void ICON_INIT(void);

#endif // ICON_H
