#ifndef LIFT_H
#define LIFT_H

#define LIFT_TYPE	14
#define LIFT_NAME	"Lift"
#define	LIFT_INIT	liftInitFuncList
#define LIFT_PROPS	2
#define LIFT_LASTING	0.5	// 10 sec

#define LIFT_PROPZ	0
#define LIFT_PROPHNAME	1

#define LIFT_INCRZ	0.01	// 1 cm
#define LIFT_DENSITY	10.0
#define LIFT_STEP	0.05	// 5 cm
#define LIFT_DEF_SPEED	1	// 1 m/s
#define LIFT_DEF_HEIGHT	4	// 4 m
#define LIFT_DEF_TOP	1	// first floor
#define LIFT_DEF_BOT	-1	// first underground


/**
 * Lift Class
 */
class Lift: public WObject {
 public:
  static const uint8_t props;
  float height;		///< level height
  float speed;		///< vertical speed
  float dest;		///< destination
  int bot;		///< bottom level
  int top;		///< top level
  uint8_t weight;
  //pd class User *user;	///< carried user

  static const WClass wclass;	///< class variable
  virtual const WClass* getWClass() {return &wclass;};

  Lift(char *l);

  static WObject * (creator)(char *l);
  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t sec, time_t usec, float *lasting);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  //pd virtual void whenNoIntersect(WObject *pcur, WObject *pold);
  virtual bool whenIntersectOut(WObject *pcur, WObject *pold);
  virtual void quit();
};

void LIFT_INIT(void);

#endif // LIFT_H
