#include "global.h"
#include "wo.h"
#include "matrix.h"


const WClass Matrix::wclass(MATRIX_TYPE, "Matrix", Matrix::creator);
void matrixInitFuncList(void) {}


WObject * Matrix::creator(char *l)
{
  return new Matrix(l);
}

Matrix::Matrix(char *l)
{
  char opstr[8];
  op =  MATRIX_NONE;

  l = parseObject(l);
  if (!strncmp(l, "op", 2)) {
    l = parseString(l, opstr, "op");
    if (!strncmp(opstr, "push", 4))
      op = MATRIX_PUSH;
    else if (!strncmp(opstr, "pop", 3))
      op = MATRIX_POP;
    else if (!strncmp(opstr, "rot", 3)) {
      op = MATRIX_ROT;
      l = parseRotation(l);
    }
    else if (!strncmp(opstr, "trans", 5)) {
      op = MATRIX_TRANS;
      l = parseTranslation(l);
    }
    else if (!strncmp(opstr, "scale", 5)) {
      op = MATRIX_SCALE;
      l = parseTranslation(l);
    }
  }

  initializeObject(LIST_INVISIBLE);
} 

void Matrix::render()
{
  switch (op) {
  case MATRIX_PUSH:
    glPushMatrix(); break;
  case MATRIX_POP:
    glPopMatrix(); break;
  case MATRIX_ROT:
    glRotatef(pos.az, pos.x, pos.y, pos.z); break;
  case MATRIX_TRANS:
    glTranslatef(pos.x, pos.y, pos.z); break;
  case MATRIX_SCALE:
    glScalef(pos.x, pos.y, pos.z); break;
  }
}
