#include "global.h"
#include "wo.h"
#include "music.h"

#include "app.h"	// startmp3 startmidi

const WClass Music::wclass(MUSIC_TYPE, "Music", Music::creator);

void Play(Music *po, void *d, time_t s, time_t u);


/* creation from a file */
WObject * Music::creator(char *l)
{
  return new Music(l);
}

Music::Music(char *l)
{
  status = MUSIC_INACTIVE;
  char statestr[8];
  statestr[0] = '\0';

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);
  while (l) {
    if (!strncmp(l, "state", 5)) {
      l = parseString(l, statestr, "state");
    }
  }

  enableBehavior(COLLIDE_NEVER);
  initializeObject(LIST_STILL);

  char *pext = strrchr(name.url, '.');
  pext++;
  if (!strncmp(pext, "mp3", 3) || !strncmp(pext, "mp2", 3)) {
    fmt = MUSIC_FMT_MP3;
  }
  else if (!strncmp(pext, "mid", 3)) {
    fmt = MUSIC_FMT_MIDI;
  }
  if (! strncmp(statestr, "play", 4)) {
    Play(this, NULL, 0L, 0L);
  }
} 

/* intersection: stop */
void Music::whenIntersect(WObject *pcur, WObject *pold)
{
  pold->copyPositionAndBB(pcur);
}

/* play */
#if MUSICC
void Music::Play(void *d, time_t s, time_t u)
{
  if (status == MUSIC_INACTIVE) {
    switch (fmt) {
    case MUSIC_FMT_MP3:
      App::startmp3(name.url);
      break;
    case MUSIC_FMT_MIDI:
      App::startmidi(name.url);
      break;
    }
    status = MUSIC_PLAYING;
  }
}
#else
void Play(Music *po, void *d, time_t s, time_t u)
{
  if (po->status == MUSIC_INACTIVE) {
    switch (po->fmt) {
    case MUSIC_FMT_MP3:
      App::startmp3(po->name.url);
      break;
    case MUSIC_FMT_MIDI:
      App::startmidi(po->name.url);
      break;
    }
    po->status = MUSIC_PLAYING;
  }
}
#endif

/* stop */
#if MUSICC
void Music::Stop(void *d, time_t s, time_t u)
{
  if (status == MUSIC_PLAYING || status == MUSIC_LOOP) {
    switch (fmt) {
    case MUSIC_FMT_MP3:
      App::stopmp3();
      break;
    case MUSIC_FMT_MIDI:
      App::stopmidi();
      break;
    }
    status = MUSIC_INACTIVE;
  }
}
#else
void Stop(Music *po, void *d, time_t s, time_t u)
{
  if (po->status == MUSIC_PLAYING || po->status == MUSIC_LOOP) {
    switch (po->fmt) {
    case MUSIC_FMT_MP3:
      App::stopmp3();
      break;
    case MUSIC_FMT_MIDI:
      App::stopmidi();
      break;
    }
    po->status = MUSIC_INACTIVE;
  }
}
#endif

/* pause */
#if MUSICC
void Music::Pause(void *d, time_t s, time_t u)
{
  if (status == MUSIC_PLAYING || status == MUSIC_LOOP) {
    switch (fmt) {
    case MUSIC_FMT_MP3:
      App::pausemp3();
      break;
    case MUSIC_FMT_MIDI:
      App::pausemidi();
      break;
    }
    status = MUSIC_PAUSE;
  }
}
#else
void Pause(Music *po, void *d, time_t s, time_t u)
{
  if (po->status == MUSIC_PLAYING || po->status == MUSIC_LOOP) {
    switch (po->fmt) {
    case MUSIC_FMT_MP3:
      App::pausemp3();
      break;
    case MUSIC_FMT_MIDI:
      App::pausemidi();
      break;
    }
    po->status = MUSIC_PAUSE;
  }
}
#endif

/* continue */
#if MUSICC
void Music::Cont(void *d, time_t s, time_t u)
{
  if (status == MUSIC_PAUSE) {
    switch (fmt) {
    case MUSIC_FMT_MP3:
      App::contmp3();
      break;
    case MUSIC_FMT_MIDI:
      App::contmidi();
      break;
    }
    status = MUSIC_PLAYING;
  }
}
#else
void Cont(Music *po, void *d, time_t s, time_t u)
{
  if (po->status == MUSIC_PAUSE) {
    switch (po->fmt) {
    case MUSIC_FMT_MP3:
      App::contmp3();
      break;
    case MUSIC_FMT_MIDI:
      App::contmidi();
      break;
    }
    po->status = MUSIC_PLAYING;
  }
}
#endif

/* loop */
#if MUSICC
void Music::Loop(void *d, time_t s, time_t u)
{
  if (status != MUSIC_INACTIVE)
    status = MUSIC_LOOP;
}
#else
void Loop(Music *po, void *d, time_t s, time_t u)
{
  if (po->status != MUSIC_INACTIVE)
    po->status = MUSIC_LOOP;
}
#endif

void Music::quit()
{
  switch (fmt) {
  case MUSIC_FMT_MP3:
    App::stopmp3();
    break;
  case MUSIC_FMT_MIDI:
    App::stopmidi();
    break;
  }
}

void musicInitFuncList(void)
{
#if MUSICC
  setActionHandler(MUSIC_TYPE, 0, WO_ACTION2 Music::Play, "Play");
  setActionHandler(MUSIC_TYPE, 1, WO_ACTION2 Music::Stop, "Stop");
  setActionHandler(MUSIC_TYPE, 2, WO_ACTION2 Music::Pause, "Pause");
  setActionHandler(MUSIC_TYPE, 3, WO_ACTION2 Music::Cont, "Continue");
  setActionHandler(MUSIC_TYPE, 4, WO_ACTION2 Music::Loop, "Loop");
#else
  setActionFunc(MUSIC_TYPE, 0, WO_ACTION Play, "Play");
  setActionFunc(MUSIC_TYPE, 1, WO_ACTION Stop, "Stop");
  setActionFunc(MUSIC_TYPE, 2, WO_ACTION Pause, "Pause");
  setActionFunc(MUSIC_TYPE, 3, WO_ACTION Cont, "Continue");
  setActionFunc(MUSIC_TYPE, 4, WO_ACTION Loop, "Loop");
#endif
}
