#include "global.h"
#include "wo.h"
#include "world.h"	// worlds
#include "user.h"	// USER_TYPE

#include "net.h"	// NetObject
#include "gui.h"	// GuiRemoveUser
#include "vgl.h"	// ~Solid


PropertyFuncList putPropertyFunc, getPropertyFunc;


/*
 * get_ functions
 */
void get_xy(WObject *that, Payload *pp)
{
  Pos oldpos = that->pos;

  pp->getPayload("ff", &that->pos.x, &that->pos.y);
  that->updateObject(oldpos);
}

void get_z(WObject *that, Payload *pp)
{
  Pos oldpos = that->pos;

  pp->getPayload("f", &that->pos.z);
  that->updateObject(oldpos);
}

void get_az(WObject *that, Payload *pp)
{
  Pos oldpos = that->pos;

  pp->getPayload("f", &that->pos.az);
  that->updateObject(oldpos);
}

void get_ay(WObject *that, Payload *pp)
{
  Pos oldpos = that->pos;

  pp->getPayload("f", &that->pos.ay);
  that->updateObject(oldpos);
}

void get_ax(WObject *that, Payload *pp)
{
  Pos oldpos = that->pos;

  pp->getPayload("f", &that->pos.ax);
  that->updateObject(oldpos);
}

void get_hname(WObject *that, Payload *pp)
{
  pp->getPayload("s", that->name.class_name);
}

/*
 * put_ functions
 */
void put_xy(WObject *that, Payload *pp)
{ pp->putPayload("ff", that->pos.x, that->pos.y); }

void put_z(WObject *that, Payload *pp)
{ pp->putPayload("f", that->pos.z); }

void put_az(WObject *that, Payload *pp)
{ pp->putPayload("f", that->pos.az); }

void put_ay(WObject *that, Payload *pp)
{ pp->putPayload("f", that->pos.ay); }

void put_ax(WObject *that, Payload *pp)
{ pp->putPayload("f", that->pos.ax); }

void put_hname(WObject *that, Payload *pp)
{ pp->putPayload("s", that->name.class_name); }

/* Gets property from Network */
void WObject::getProperty(uint8_t prop_id, Payload *pp)
{
  if (! isValid()) {
    error("getProperty: FIXME bad type=%d", type);
    return;
  }
#if 0 //debug
  error("getProperty: prop=%d type=%d", prop_id, type);
#endif //debug
  if (! getPropertyFunc[prop_id][type].pf) {
    error("getProperty: prop=%d doesn't match the object type=%d",
	     prop_id, type);
    return;
  }
#if 0
  getPropertyFunc[prop_id][type].pf(pp);
#else
  getPropertyFunc[prop_id][type].pf(this, pp);
#endif
}

/* Puts property to Network */
void WObject::putProperty(uint8_t prop_id, Payload *pp)
{
  if (! putPropertyFunc[prop_id][type].pf) {
    error("putProperty: prop=%d undefined for object=%d", prop_id, type);
    return;
  }
#if 0
  putPropertyFunc[prop_id][type].pf(pp);
#else
  putPropertyFunc[prop_id][type].pf(this, pp);
#endif
}

void WObject::deleteReplica()
{
  if (this != worlds->plocaluser) {
    if (type == USER_TYPE)
      GuiRemoveUser((User *) this);

    // MAYBE DO toDelete()
    //
    //toDelete();	//pd

    deleteObjectFromGrid();
    mobileList = deleteObjectFromList(mobileList);
    if (soh) {
      delete soh;	// delete Solid
      soh = NULL;
    }
    delete noh;	// delete NetObject
    noh = NULL;
  }
  else
    notice("You're trying to kill me, but I'm back!");
}
