#include "global.h"
#include "wo.h"
#include "sheet.h"

#include "net.h"	// NetObject
#include "vgl.h"	// bbsize


const WClass Sheet::wclass(SHEET_TYPE, "Sheet", NULL);
const uint8_t Sheet::props = SHEET_PROPS;

static uint16_t oid = 0;


Sheet::Sheet(Book* _book, char* l, uint8_t _status, void* d, time_t s, time_t u)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
 
  book = _book;

  /* adapt position */
  aright = book->aright;
  aleft  = book->aleft;
  status = _status;
  aspeed = book->v * SHEET_ASPEED;
  lspeed = SHEET_LSPEED;
  center.v[0] = pos.x;	// hinge
  center.v[1] = pos.y;
  center.v[2] = pos.z;
  size.v[0] = soh->bbsize.v[0];
  pos.x = center.v[0] + size.v[0] * Cos(pos.az);
  pos.y = center.v[1] + size.v[0] * Sin(pos.az);
  pos.z = center.v[2];

  /* local creation */
  type = SHEET_TYPE;
  enableBehavior(PERSISTENT);
  enableBehavior(COLLIDE_NEVER);
  initializeObject(LIST_MOBILE);
  setMaxLasting(SHEET_LASTING);

  /* network creation */
  createPermanentNetObject(props, ++oid);
  //pd noh->declareObjCreation();
}

bool Sheet::isMoving()
{
  return (move.ttl > 0.0005);
}

void Sheet::changePosition(float lasting)
{
  pos.az += lasting * move.aspeed.v[0];

  center.v[0] += lasting * move.lspeed.v[0];
  center.v[1] += lasting * move.lspeed.v[1];
  center.v[2] += lasting * move.lspeed.v[2];

  // pour x et y, on utilise l'attribut center pour garder une trace du passe
  // (sinon, pb car x et y sont remis par defaut au centre de la box)
  pos.x = center.v[0] + size.v[0] * Cos(pos.az);
  pos.y = center.v[1] + size.v[0] * Sin(pos.az);
  pos.z = center.v[2];
}

void Sheet::updateTime(time_t sec, time_t usec, float *lasting)
{
  if (move.aspeed.v[0] == aspeed) // en cours de turnRight
    move.ttl = MIN(ABSF(deltaAngle(pos.az, aright)/move.aspeed.v[0]), move.ttl);
  else
    if (move.aspeed.v[0] == -aspeed) // en cours de turnLeft
      move.ttl = MIN(ABSF(deltaAngle(pos.az, aleft)/move.aspeed.v[0]), move.ttl);

  *lasting = diffTime(sec, usec);
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    stopImposedMovement();

    if (book->stillToTurn>0)
      book->forward(NULL, 0, 0);
    book->stillToTurn--;

    if (book->stillToTurn2>0)
      book->backward(NULL, 0, 0);
    book->stillToTurn2--;
  }
}

bool Sheet::updateToNetwork(const Pos &oldpos)
{
  bool change = false;

  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    noh->declareObjDelta(SHEET_PROPXY);
    change = true;
  }
  if (pos.z != oldpos.z) {
    noh->declareObjDelta(SHEET_PROPZ);
    change = true;
  }
  if (pos.az != oldpos.az) {
    noh->declareObjDelta(SHEET_PROPAZ);
    change = true;
  }
  return change;
}

void Sheet::whenIntersect(WObject *pcur, WObject *pold)
{
  if (status == SHEET_RIGHT && projectMovementOnObject(pcur->pos, pold->pos, pos))
    pcur->updateObject(pold->pos);
  else
    pold->copyPositionAndBB(pcur);
}

/**
 * SheetCreate: called by Book
 * 
 * status indicates on which heap (left or right) is the sheet.
 * num indique a quel champ de book la feuille doit etre rattachee
 */
void sheetCreate(Book* book, char* l, uint8_t status, int num, void* d, time_t s, time_t u)
{
  switch (num) {
  case 0:
    book->rightSide = new Sheet(book, l, status, d, s, u);
    break;
  case 1:
    book->leftSide = new Sheet(book, l, status, d, s, u);
    break;
  default:
    book->mobileSheet = new Sheet(book, l, status, d, s, u);
    break;
  }
}

void Sheet::quit()
{
  oid = 0;
}

void sheetInitFuncList(void)
{
  getPropertyFunc[SHEET_PROPXY][SHEET_TYPE].pf = WO_PAYLOAD get_xy;
  getPropertyFunc[SHEET_PROPZ][SHEET_TYPE].pf = WO_PAYLOAD get_z;
  getPropertyFunc[SHEET_PROPAZ][SHEET_TYPE].pf = WO_PAYLOAD get_az;
  getPropertyFunc[SHEET_PROPHNAME][SHEET_TYPE].pf = WO_PAYLOAD get_hname;

  putPropertyFunc[SHEET_PROPXY][SHEET_TYPE].pf = WO_PAYLOAD put_xy;
  putPropertyFunc[SHEET_PROPZ][SHEET_TYPE].pf = WO_PAYLOAD put_z;
  putPropertyFunc[SHEET_PROPAZ][SHEET_TYPE].pf = WO_PAYLOAD put_az;
  putPropertyFunc[SHEET_PROPHNAME][SHEET_TYPE].pf = WO_PAYLOAD put_hname;

  // invisible method, called by Book
  setActionFunc(SHEET_TYPE, SHEET_CREATE, WO_ACTION sheetCreate, "");
}
