#ifndef STARS_H
#define STARS_H

#define STARS_TYPE	30
#define STARS_NAME	"Stars"
#define	STARS_INIT	starsInitFuncList

#define STARS_MAX	200	// 400
#define STARS_MAXPOS	5000	// 10000
#define STARS_WARP	10.0
#define STARS_WIDTH	100
#define STARS_HEIGHT	100
#define STARS_SPEED	1.0	// 1 m/s
#define STARS_MAXANGLE	360

enum {
  STARS_NORMAL = 0,
  STARS_WEIRD = 1
};
enum {
  STARS_STREAK = 0,
  STARS_CIRCLE = 1
};

typedef struct _starRec {
  float x[2], y[2], z[2];
  float offsetX, offsetY, offsetR, rotation;
} starRec;

/**
 * Stars Class
 */
class Stars: public WObject {
 private:
  uint16_t number;	///< number of stars
  uint16_t maxpos;	///< maxpos
  uint16_t count;	///< counter
  float speed;		///< speed
  float warp;		///< limit
  starRec *stars;

  virtual void newStar(int n, int d);
  virtual void moveStars();
  virtual int pointStar(int n);
  virtual void showStar(int n);
  virtual void updateStars();

 public:
  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Stars(char *l);

  static WObject * (creator)(char *l);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();

};

void STARS_INIT(void);

#endif // STARS_H
