#include "global.h"
#include "wo.h"
#include "text.h"

#include "txf.h"	// TexFont


const WClass Text::wclass(TEXT_TYPE, "Text", Text::creator);
void textInitFuncList(void) {}

static const GLfloat color[4] = {0, 1, 0, 0.5};


/* creation from a file */
WObject * Text::creator(char *l)
{
  return new Text(l);
}

Text::Text(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseQuotedString(l, text, "text");
  l = parseString(l, name.url, "font");
  text[TEXT_MAXLEN - 1] = '\0';

  enableBehavior(NO_SELECTABLE);
  initializeObject(LIST_STILL);

  if ((txf = getTexfontFromCache(name.url)) == NULL) {
    error("Text: can't load %s", name.url);
    return;
  }

#if !defined(WITH_TINYGL)	// mipmaps & glAlphaFunc missing
  txfEstablishTexture(txf, 0, GL_TRUE);		// mipmaps
#else
  txfEstablishTexture(txf, 0, GL_FALSE);
#endif
} 

void Text::render()
{
  glPushMatrix();
  glDisable(GL_LIGHTING);	// no lighting on texts
  glEnable(GL_TEXTURE_2D);
  //pdcull glDisable(GL_CULL_FACE);	// to see both faces
  glEnable(GL_BLEND);
  //pd glEnable(GL_COLOR_MATERIAL);

  txfBindFontTexture(txf);	// Bellot the best!
#if !defined(WITH_TINYGL)	// glAlphaFunc & glTexEnvf missing
  //pd glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, color);
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
#endif

  glTranslatef(pos.x, pos.y, pos.z);
  glRotatef(RADIAN2DEGREE(pos.az), 0, 0, 1);
  glRotatef(RADIAN2DEGREE(pos.ax), 1, 0, 0);
  glScalef(TEXT_SCALE, TEXT_SCALE, TEXT_SCALE);

  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, color);
  //pd glColor4fv(color);

  txfRenderString(txf, text, (int) strlen(text));

  //pd glDisable(GL_COLOR_MATERIAL);
  glDisable(GL_BLEND);
  //pdcull glEnable(GL_CULL_FACE);
  glDisable(GL_TEXTURE_2D);
  glEnable(GL_LIGHTING);	// restore lighting
  glPopMatrix();
}

void Text::quit()
{
#if 0 //crashes
  txfUnloadFont(txf);
#endif
}
