#include "global.h"
#include "wo.h"
#include "world.h"
#include "user.h"
#include "move.h"	// GRAVITY
#include "carrier.h"	// Carrier
#include "cart.h"	// Cart
#include "thing.h"

#include "net.h"	// NetObject


const WClass Thing::wclass(THING_TYPE, "Thing", Thing::creator);
const uint8_t Thing::props = THING_PROPS;

static uint16_t oid = 0;


/* creation from a file */
WObject * Thing::creator(char *l)
{
  return new Thing(l);
}

Thing::Thing(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  enableBehavior(TAKABLE);
  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_MOBILE);
  setMaxLasting(THING_LASTING);
  createPermanentNetObject(props, ++oid);

  enablePermanentMovement();	// gravity

  lspeed = THING_LSPEED;
  state.state = THING_INACTIVE;
} 

void Thing::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = diffTime(sec, usec);
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl /* = THING_TTL */ ;
    stopImposedMovement();
  }
}

bool Thing::isMoving()
{
  return (move.ttl > 0.0005);
}

void Thing::changePosition(float lasting)
{
  if (state.state == THING_DROP)
    return;
  if (state.state != THING_INACTIVE) {
    WObject *po;

#if 1 //gpl group
    if (up_p || !soh) { // group of objects (has a father or has no solid)
      for (po = prev(); po && po->prev() == prev(); po = po->next()) {
        trace(DBG_WO, "prev=%p po=%p po->prev=%p po->next=%p", prev(), po, po->prev(), po->next());
#else
    if (pos.group) {    // group of objects
      for (po = prevg; po && po->prevg == prevg; po = po->nextg) {
        trace(DBG_WO, "prev=%p po=%p po->prev=%p po->next=%p", prevg, po, po->prevg, po->nextg);
#endif //gpl group
        po->pos.x += lasting * move.lspeed.v[0];
        po->pos.y += lasting * move.lspeed.v[1];
        po->pos.z += lasting * move.lspeed.v[2];
        po->pos.az += lasting * move.aspeed.v[0];
        trace(DBG_WO, "thingChangePosition: x=%.2f y=%.2f z=%.2f ttl=%.2f lasting=%.2f", po->pos.x, po->pos.y, po->pos.z, move.ttl, lasting);
      }
    }
    else {	// only one object
      pos.x += lasting * move.lspeed.v[0];
      pos.y += lasting * move.lspeed.v[1];
      pos.z += lasting * move.lspeed.v[2];
      pos.az += lasting * move.aspeed.v[0];
      trace(DBG_WO, "thingChangePosition: x=%.2f y=%.2f z=%.2f ttl=%.2f lasting=%.2f", pos.x, pos.y, pos.z, move.ttl, lasting);
    }
  }
}

void Thing::changePermanent(float lasting)
{
  static float lastz = 0.0;

  if (state.state == THING_DROP) {
    trace(DBG_WO, "thingChangePermanent: x=%.2f y=%.2f z=%.2f ttl=%.2f lasting=%.2f", pos.x, pos.y, pos.z, move.ttl, lasting);
    lastz = pos.z;
    /* drop this thing by gravity */
    if (pos.group) {	// group of objects
      WObject *po;

#if 1 //gpl
      for (po = prev(); po && po->prev() == prev(); po = po->next()) {
        trace(DBG_WO, "prev=%p po=%p po->prev=%p po->next=%p", prev(), po, po->prev(), po->next());
#else
      for (po = prevg; po && po->prevg == prevg; po = po->nextg) {
        trace(DBG_WO, "prev=%p po=%p po->prev=%p po->next=%p", prevg, po, po->prevg, po->nextg);
#endif //gpl
        po->pos.z -= lasting * GRAVITY;
      }
    }
    else	// only one object
      pos.z -= lasting * GRAVITY;

    /* test if finished */
    if (move.ttl == 0 /* || ABSF(lastz - pos.z) < 0.001 */) {
      state.state = THING_INACTIVE;
      lastz = 0.0;
    }
  }
}

bool Thing::updateToNetwork(const Pos &oldpos)
{
  bool change = false;

  if (state.state != THING_INACTIVE) {
    if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
      if (pos.group) {	// group of objects
        WObject *po;
#if 1 //gpl
        for (po = prev(); po && po->prev() == prev(); po = po->next()) {
#else
        for (po = prevg; po && po->prevg == prevg; po = po->nextg) {
#endif //gpl
          trace(DBG_WO, "Thing::updateToNetwork: x=%.2f y=%.2f", po->pos.x, po->pos.y);
          po->noh->declareObjDelta(THING_PROPXY);
        }
      }
      else {
        trace(DBG_WO, "Thing::updateToNetwork: x=%.2f y=%.2f", pos.x, pos.y);
        noh->declareObjDelta(THING_PROPXY);
      }
      change = true;
    }
    if (ABSF(pos.z - oldpos.z) > 0.1) {
      if (pos.group) {	// group of objects
        WObject *po;
#if 1 //gpl
        for (po = prev(); po && po->prev() == prev(); po = po->next()) {
#else
        for (po = prevg; po && po->prevg == prevg; po = po->nextg) {
#endif //gpl
          po->noh->declareObjDelta(THING_PROPZ);
        }
      }
      else
        noh->declareObjDelta(THING_PROPZ);
      change = true;
    }
    if (pos.az != oldpos.az) {
      if (pos.group) {	// group of objects
        WObject *po;
#if 1 //gpl
        for (po = prev(); po && po->prev() == prev(); po = po->next()) {
#else
        for (po = prevg; po && po->prevg == prevg; po = po->nextg) {
#endif //gpl
          po->noh->declareObjDelta(THING_PROPAZ);
        }
      }
      else
        noh->declareObjDelta(THING_PROPAZ);
      change = true;
    }
  }
  return change;
}

void thingTake(Thing *po, void *data, time_t sec, time_t usec)
{
  po->disablePermanentMovement();
  po->move.lspeed.v[0] = - po->lspeed * Cos(worlds->plocaluser->pos.az);
  po->move.lspeed.v[1] = - po->lspeed * Sin(worlds->plocaluser->pos.az);
  po->move.lspeed.v[2] = 0;
  po->move.aspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->initImposedMovement(THING_TTL);
  po->state.state = THING_TAKEN;
}

void thingPush(Thing *po, void *data, time_t sec, time_t usec)
{
  po->disablePermanentMovement();
  po->move.lspeed.v[0] = po->lspeed * Cos(worlds->plocaluser->pos.az);
  po->move.lspeed.v[1] = po->lspeed * Sin(worlds->plocaluser->pos.az);
  po->move.lspeed.v[2] = 0;
  po->move.aspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->initImposedMovement(THING_TTL);
  po->state.state = THING_TAKEN;
}

void thingRot(Thing *po, void *data, time_t sec, time_t usec)
{
  po->disablePermanentMovement();
  po->move.lspeed.v[0] = 0;
  po->move.lspeed.v[1] = 0;
  po->move.lspeed.v[2] = 0;
  po->move.aspeed.v[0] = 0.88; // 0.88 rd/s
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->initImposedMovement(THING_TTL);
  po->state.state = THING_TAKEN;
}

void thingDrop(Thing *po, void *data, time_t sec, time_t usec)
{
  if (po->state.state == THING_INACTIVE)
    return;
  po->disablePermanentMovement();
  po->initImposedMovement(THING_TTL);
  po->state.state = THING_DROP;
}

static
void thingAddToCart(Thing *po, void *data, time_t sec, time_t usec)
{
  worlds->plocaluser->cart->addObjectToCart(po);
}

void Thing::whenIntersect(WObject *pcur, WObject *pold)
{
  trace(DBG_WO, "thingIntersect: xyz=%.2f,%.2f,%.2f", pos.x, pos.y, pos.z);
  //PD pold->copyPositionAndBB(pcur);
}

void Thing::quit()
{
  oid = 0;
}

void thingInitFuncList(void)
{
  getPropertyFunc[THING_PROPXY][THING_TYPE].pf = WO_PAYLOAD get_xy;
  getPropertyFunc[THING_PROPZ][THING_TYPE].pf = WO_PAYLOAD get_z;
  getPropertyFunc[THING_PROPAZ][THING_TYPE].pf = WO_PAYLOAD get_az;
  getPropertyFunc[THING_PROPHNAME][THING_TYPE].pf = WO_PAYLOAD get_hname;

  putPropertyFunc[THING_PROPXY][THING_TYPE].pf = WO_PAYLOAD put_xy;
  putPropertyFunc[THING_PROPZ][THING_TYPE].pf = WO_PAYLOAD put_z;
  putPropertyFunc[THING_PROPAZ][THING_TYPE].pf = WO_PAYLOAD put_az;
  putPropertyFunc[THING_PROPHNAME][THING_TYPE].pf = WO_PAYLOAD put_hname;

#if 1 //gpl
  setActionFunc(THING_TYPE, 0, WO_ACTION takend, "Take");
  setActionFunc(THING_TYPE, 1, WO_ACTION thingAddToCart, "Basket");
#else
  setActionFunc(THING_TYPE, 0, WO_ACTION thingTake, "Take");
  setActionFunc(THING_TYPE, 1, WO_ACTION thingPush, "Push");
  setActionFunc(THING_TYPE, 2, WO_ACTION thingRot, "Rot");
  setActionFunc(THING_TYPE, 3, WO_ACTION thingDrop, "Drop");
#endif //gpl
}
