/*******************************************************/
/*                      VNC Object                     */
/*                                                     */
/*  Thanks to that object, you can launch a VNC viewer */
/* into a VReng world. So, you must have a VNC server  */
/* running on a machine (locally or remotely).         */
/*                                                     */
/*  The syntax to add an object into a vre file is :   */
/*    [vnc]                                            */
/*    (name) pos [server] geometry                     */
/*  where                                              */
/*    pos <- x y z az ax                               */
/*    server <- server=servername,port,password        */
/*    geometry <- cf VReng specs (e.g. size=sx,sy,sz)  */
/*                                                     */
/*  If a server was entered in the vre file, the       */
/* server is connected...                              */
/*                                                     */

#ifndef VNC_H
#define VNC_H

#define VNC_TYPE	35
#define VNC_NAME	"Vnc"
#define	VNC_INIT	vncInitFuncList

#define VNC_DEF_PORT	5901

#include <GL/gl.h>
#include "vnc/vncclient.h"
#include "vnc/vncauth.h"

/**
 * Vnc Class
 */
class Vnc : public WObject {
 public:

  GLfloat vertices[10*3];	///< geometry data
  GLuint tex_num;		///< texture data
  int tex_width;
  int tex_height;
  GLubyte *tex_pixmap;
  float u,v;
  GLuint borderlist;
  GLuint screenlist;
  GLfloat color[3];
  GLint viewport[4];
  GLdouble modelMatrix[16];
  GLdouble projMatrix[16];	///< projection data coordinates 
  bool isConnected;
  bool isServerDefined;
  char serverName[40];
  int port;
  char passwdFile[40];		///< server connection data
  VNCClientTextured* vncClient;
  fd_set rmask;
  struct timeval delay; 

  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};

  Vnc(char *l);

  static WObject * (creator)(char *l);

  virtual void changePermanent(float lasting);
  /**< Called each frame - check if ths texture has to be updated */

  virtual void render();
  /**< Render the object */

  virtual void quit();
  /**< Called when the object is destroy */

  virtual char * parseVNCServer(char *ptok);
  /**< Parses this object */

  virtual void defaultTexture();
  /**< Build a default texture */

  virtual void drawBorder();
  /**< Build the screen border */

  virtual void drawScreen();
  /**< Draw the screen */

  virtual void buildScreen();
  /**< Build the screen */

  virtual void getVncCoords(int &x,int &y);
  /**< Convert VReng screen coordinates to VNC screen coordinates */

  virtual bool redirectEvent(int x, int y, int button);
  virtual bool redirectEvent(const char *touche, bool is_down);
  /**< Redirect Events to VNC Server */

  virtual void connectServer();
  virtual void convert(const char *server, const char *port, const char *passwd);
  /**< updates server parameters from UStr from the dialog window */

};

void VNC_INIT(void);

#endif // VNC_H
