#include "global.h"

#if defined(WITH_MYSQL) && defined(HAVE_LIBMYSQLCLIENT)

#include "vrmysql.h"
 

// local variable
static VRSql *_sql = NULL;


/** Establishes a link with the mysql server */
VRSql * VRSql::establishSql()
{
#if 0
  mysql_init(_sql->linksql);
  if (! mysql_real_connect(_sql->linksql, DEF_MYSQL_SERVER, MYSQL_USER, MYSQL_PASSWD, MYSQL_DB, 0, NULL, 0)) {
    error("establishSql: %s can't connect %s", MYSQL_USER, DEF_MYSQL_SERVER);
    return _sql = NULL;
  }
#else
  if ((_sql->linksql = mysql_connect(NULL, DEF_MYSQL_SERVER, MYSQL_USER, MYSQL_PASSWD)) == NULL) {
    error("establishSql: %s can't connect %s", MYSQL_USER, DEF_MYSQL_SERVER);
    return _sql = NULL;
  }
  if (mysql_select_db(_sql->linksql, MYSQL_DB) != 0) {
    return _sql = NULL;
  }
#endif
  trace(DBG_WO, "establishSql: host=%s user=%s db=%s sql=%p", DEF_MYSQL_SERVER, MYSQL_USER, MYSQL_DB, _sql);
  return _sql;
}

/** Allocates VRSql */
VRSql * VRSql::initVRSql()
{
  if (! _sql) {
    if ((_sql = new VRSql) == NULL)
      return NULL;
  }
  establishSql();
  return _sql;
}

/** Returns VRSql ptr */
VRSql * VRSql::getVRSql()
{
  return _sql;
}

/** Closes the sql link */
void VRSql::byeVRSql()
{
  if (_sql) {
    mysql_close(_sql->linksql);  
    delete[] _sql;
    _sql = NULL;
  }
}

/** Updates an entry in the sql table */
void VRSql::updateStateObject(const char *worldname, const char *objname, int state)
{
  if (! _sql)
    return;

  char sqlcmd[BUFSIZ];
  sprintf(sqlcmd, "update %s set %s=%d where %s='%s@%s'",
          MYSQL_TABLE, MYSQL_STATE, state, MYSQL_NAME, objname, worldname);
  trace(DBG_WO, "updateStateObject: %s", sqlcmd);
  if (mysql_query(linksql, sqlcmd) != 0) {
    trace(DBG_WO, "updateStateObject: update err: %s", sqlcmd);
#if HAVE_MYSQL_ERROR
    trace(DBG_WO, "mysql_error: %s", mysql_error(linksql));
#endif
  }
}

/** Gets values from an entry in the sql table */
int VRSql::getStateObject(const char *worldname, const char *objname)
{
  if (! _sql)
    return 0;

  int r;
  // VRSql *lsql = this;
  char sqlcmd[BUFSIZ];

  sprintf(sqlcmd, "select %s from %s where %s='%s@%s'",
          MYSQL_STATE, MYSQL_TABLE, MYSQL_NAME, objname, worldname);
  trace(DBG_WO, "getStateObject: %s", sqlcmd);
  if ((r = mysql_query(_sql->linksql, sqlcmd)) != 0) {
    trace(DBG_WO, "getStateObject: query select failed err=%d", r);
#if HAVE_MYSQL_ERROR
    trace(DBG_WO, "mysql_error: %s", mysql_error(_sql->linksql));
#endif
    return -1;
  }

  MYSQL_RES *result = mysql_store_result(_sql->linksql);
  if (! result) {
    trace(DBG_WO, "getStateObject: result null");
#if HAVE_MYSQL_ERROR
    trace(DBG_WO, "mysql_error: %s", mysql_error(_sql->linksql));
#endif
    return -1;
  }

  MYSQL_ROW line = mysql_fetch_row(result);
  if (! line) {	// not in table
    // insert into table
    sprintf(sqlcmd, "insert into %s (%s,%s) values ('%s@%s', '0')",
            MYSQL_TABLE, MYSQL_NAME, MYSQL_STATE, objname, worldname);
    trace(DBG_WO, "getStateObject: %s", sqlcmd);
    if (mysql_query(_sql->linksql, sqlcmd) != 0) {
      trace(DBG_WO, "getStateObject: query insert failed");
#if HAVE_MYSQL_ERROR
      trace(DBG_WO, "mysql_error: %s", mysql_error(_sql->linksql));
#endif
      return -1;
    }
    return -1;
  }

  int state = (! line || line[0] == NULL ? -1 : atoi(line[0]));
  mysql_free_result(result);
  return state;
}

#endif // WITH_MYSQL
