#ifndef VRMYSQL_H
#define VRMYSQL_H

#if defined(WITH_MYSQL) && defined(HAVE_MYSQL_MYSQL_H) && defined(HAVE_LIBMYSQLCLIENT)

/**
 * MySql encapsulation of calls to the vreng database
 */

#define MYSQL_DB	"vreng"		// database
#define MYSQL_TABLE	"persistence"	// table
#define MYSQL_NAME	"name"		// attribute
#define MYSQL_STATE	"state"		// value
#define MYSQL_USER	"vreng"		// user
#define MYSQL_PASSWD	NULL		// passwd

/**
 * VRSql Class
 */
class VRSql {
 public:
  MYSQL *linksql;

  VRSql() {};

  int getStateObject(const char *worldname, const char *objname);
  ///< returns the state of object id in the world worldname

  void updateStateObject(const char *worldname, const char *objname, int state);
  ///< updates the state of object id in the world worldname
 
  static VRSql *initVRSql();
  ///< allocates VRSql

  static VRSql *establishSql();
  ///< establishes a link with the mysql server

  static VRSql *getVRSql();
  ///< returns the sql link

  static void byeVRSql();
  ///<  closes the sql link

};

#endif // WITH_MYSQL

#endif // VRMYSQL_H
