#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "ball.h"	// BALL_TYPE
#include "dart.h"	// DART_TYPE
#include "bullet.h"	// BULLET_TYPE
#include "thing.h"	// THING_TYPE
#include "step.h"	// STEP_SIZE
#include "caul.h"	// CAULDRON_TYPE
#include "icon.h"	// ICON_TYPE
#include "wall.h"


const WClass Wall::wclass(WALL_TYPE, "Wall", Wall::creator);
void wallInitFuncList(void) {}


/* creation from a file */
WObject * Wall::creator(char *l)
{
  return new Wall(l);
}

Wall::Wall(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  if (pos.ax)
    enableBehavior(COLLIDE_ONCE);	// emulate panel
  initializeObject(LIST_STILL);
} 

/* object intersection */
void Wall::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
  case BALL_TYPE:
  case THING_TYPE:
    if (pos.ax) {
      pcur->pos.z += STEP_SIZE;   // up
      pcur->update3D();
      pcur->getBB();
    }
    if (projectMovementOnObject(pcur->pos, pold->pos, pos))
      pcur->updateObject(pold->pos);
    else
      pold->copyPosZAndBB(pcur->pos);
    break;
  case BULLET_TYPE:
  case DART_TYPE:
    pcur->toDelete();
    break;
  case ICON_TYPE:
    if (generalActionList[ICON_STICK][ICON_TYPE].method)
      generalActionList[ICON_STICK][ICON_TYPE].method(this, pcur, 0, 0);
    //pd pold->copyPositionAndBB(pcur);
    pold->copyPosZAndBB(pcur->pos);
    break;
#if 0 //TOFIX
  case CAULDRON_TYPE:
    pcur->pos.z += CAULDRON_DELTAZ;
    break;
#endif
#if 0 //TOFIX
  case BALL_TYPE:
    if (projectMovementOnObject(pcur->pos, pold->pos, pos))
      pcur->updateObject(pold->pos);
    else
      pold->copyPosAndBB(pcur->pos);
    // trace(DBG_FORCE, "bounce: pcur->z=%f pcur->origz=%f", pcur->pos.z, pcur->origz);
    if (ABSF(pcur->pos.z - pcur->origz) > 0.05) {
      pcur->pos.z = pcur->origz / 4;
      pcur->pos.z = MAX(pcur->pos.z, BALL_RADIUS);
      pcur->origz = pcur->pos.z;
      pcur->ttl = BALL_FLYTTL / 4;
      pcur->updateObject(pcur->pos);
    }
    break;
#endif
  default:
    pold->copyPositionAndBB(pcur);
  }
}
