#include "global.h"
#include "wo.h"
#include "http.h"	// httpOpen
#include "walls.h"


const WClass Walls::wclass(WALLS_TYPE, "Walls", Walls::creator);
void wallsInitFuncList(void) {}

static Walls *wallsList = NULL;
static uint16_t numwall = 0;


WObject * Walls::creator(char *l)
{
  return new Walls(l);
}

void wallsHttpReader(void *va, Http *http)
{
  Walls *po = NULL, *prev = NULL;
  float xs, xe, ys, ye, zs, ze, r, g, b;
  char line[BUFSIZ];

  httpClearBuf();

  while (http->GetLine(line)) {
    if (sscanf(line, "%f %f %f %f %f %f  %f %f %f",
	             &xs, &xe, &ys, &ye, &zs, &ze, &r, &g, &b) <= 0) {
      break;	/* EOF */
    }

    po = new Walls(xs, xe, ys, ye, zs, ze, r, g, b);

    if (! prev)
      wallsList = po;
    else
      prev->next = po;
    prev = po;
  }
  po->next = NULL;
#if 0 //pd dlist
  po->draw();
#endif //pd dlist
}

Walls::Walls(char *l)
{
  l = parseObject(l);
  l = parseUrl(l, name.url);

  enableBehavior(NO_SELECTABLE);
  initializeObject(LIST_STILL);

  httpOpen(name.url, wallsHttpReader, NULL, THREAD_NO_BLOCK);
}

Walls::Walls(float sx, float ex, float sy, float ey, float sz, float ez, float red, float green, float blue)
{
  xs = sx;
  xe = ex;
  ys = sy;
  ye = ey;
  zs = sz;
  ze = ez;
  r  = red;
  g  = green;
  b  = blue;
  next = NULL;
  numwall++;
}

static
float cmpnorm(V3 *a, V3 *b)
{
  float rx = a->v[0] - b->v[0];
  float ry = a->v[1] - b->v[1];
  float rz = a->v[2] - b->v[2];

  return rx*rx + ry*ry + rz*rz;
}

static
float dotprod(float ax, float ay, float bx, float by)
{
  return ax*bx + ay*by;
}

int wallsIntersectObject(V3 *wallscenter, V3 *wallssize, V3 *wallsnorm)
{
  Walls *walls = wallsList;
  V3 cur_wallsnorm;
  int first = 1;
  
  float oxmin = wallscenter->v[0] - wallssize->v[0];
  float oxmax = wallscenter->v[0] + wallssize->v[0];
  float oymin = wallscenter->v[1] - wallssize->v[1];
  float oymax = wallscenter->v[1] + wallssize->v[1];
  float ozmin = wallscenter->v[2] - wallssize->v[2];
  float ozmax = wallscenter->v[2] + wallssize->v[2];

  /* Now, we test the collision with all the walls */
  while (walls) {
    float wxmin = (walls->xs < walls->xe) ? walls->xs : walls->xe;
    float wxmax = (walls->xs > walls->xe) ? walls->xs : walls->xe;
    float wymin = (walls->ys < walls->ye) ? walls->ys : walls->ye;
    float wymax = (walls->ys > walls->ye) ? walls->ys : walls->ye;
    float wzmin = (walls->zs < walls->ze) ? walls->zs : walls->ze;
    float wzmax = (walls->zs > walls->ze) ? walls->zs : walls->ze;

    if ((((oxmin < wxmin) && (oxmax > wxmax)) ||
	 ((oxmin > wxmin) && (oxmax < wxmax)) ||
	 ((oxmax > wxmin) && (oxmax < wxmax)) ||
	 ((oxmin > wxmin) && (oxmin < wxmax)))
	&&
	(((oymin < wymin) && (oymax > wymax)) ||
	 ((oymin > wymin) && (oymax < wymax)) ||
	 ((oymax > wymin) && (oymax < wymax)) ||
	 ((oymin > wymin) && (oymin < wymax)))
	&&
	(((ozmin < wzmin) && (ozmax > wzmax)) ||
	 ((ozmin > wzmin) && (ozmax < wzmax)) ||
	 ((ozmax > wzmin) && (ozmax < wzmax)) ||
	 ((ozmin > wzmin) && (ozmin < wzmax)))) {
      cur_wallsnorm.v[2] = 0.;
      if (wxmin == wxmax) {
	cur_wallsnorm.v[0] = 1.;
	cur_wallsnorm.v[1] = 0.;
      }
      else {
	cur_wallsnorm.v[1] = 1.;
	cur_wallsnorm.v[0] = 0.;
      }

      /* Test which normal we take.... */
      if (dotprod(wallscenter->v[0] - wxmin, wallscenter->v[1] - wymin,
		  cur_wallsnorm.v[0], cur_wallsnorm.v[1]) < 0.) {
	cur_wallsnorm.v[0] = -cur_wallsnorm.v[0];
	cur_wallsnorm.v[1] = -cur_wallsnorm.v[1];
      }
      if (first) {
	*wallsnorm = cur_wallsnorm;
	first = 0;
      }
      else {
	if (cmpnorm(&cur_wallsnorm, wallsnorm) > 0.01)
	  return 2;
      }
    }
    walls = walls->next;
  }
  if (first)
    return 0; // No collisions
  else
    return 1;
}

void Walls::draw()
{
#if 0 //pd dlist
  wallsdlist = glGenLists(1);
  glNewList(wallsdlist, GL_COMPILE);
#endif //pd dlist
  for (Walls *walls = wallsList; walls; walls = walls->next) {
    glColor3f(walls->r, walls->g, walls->b);
    glBegin(GL_QUADS);
      glVertex3f(walls->xs, walls->ys, walls->zs);
      glVertex3f(walls->xs, walls->ys, walls->ze);
      glVertex3f(walls->xe, walls->ye, walls->ze);
      glVertex3f(walls->xe, walls->ye, walls->zs);
    glEnd();
  }
  //pd trace(DBG_FORCE, "wallsList=%p", wallsList);
#if 0 //pd dlist
  glEndList();
#endif //pd dlist
}

void Walls::render()
{
  glDisable(GL_LIGHTING);	// no lighting on walls
  glDisable(GL_CULL_FACE);	// two facets => no culling
  
#if 0 //pd dlist
  glCallList(wallsdlist);
#else //pd dlist
  draw();
#endif //pd dlist

  glEnable(GL_LIGHTING);
}

/* freeing the list allocated in wallsHttpReader callback */
void Walls::quit()
{
  while (wallsList) {
    Walls *nextwall = wallsList->next;

    delete wallsList;
    wallsList = nextwall;
  }
  wallsList = NULL;
  numwall = 0;
}
