#ifndef WATER_H
#define WATER_H

#define WATER_TYPE 	32
#define WATER_NAME 	"Water"
#define	WATER_INIT 	waterInitFuncList

#define	WATER_RATE 		10
#define	WATER_DEF_TRANSP 	0.8
#define	WATER_DEF_HEIGHT 	0.15	// 
#define	WATER_DEF_AMPLITUDE 	0.05	// original: 0.03
#define	WATER_DEF_FREQ	 	4.0	// 4 waves
#define	WATER_DEF_PHASE	 	0.0001	// original: 0.00003
#define	WATER_DEF_FOG	 	0.15

#define	WATER_INCR_AMPLITUDE	0.01
#define	WATER_INCR_FREQ 	1.
#define	WATER_INCR_PHASE	0.00005
#define	WATER_INCR_TRANSP	0.05
#define	WATER_INCR_FOG		0.05
#define	WATER_MAX_OFF		20.
#define	WATER_MESH	 	32


/**
 * Water Class
 */
class Water: public WObject {
 private:
  float rotx, roty, rotz;
  float width, depth, height;
  float off;
  bool play;
#if 0 //pdtex
  int texnum;
#endif

  virtual void setDefaults();
  virtual void draw();

 public:
  uint8_t accel;	///< acceleration toggle
  float amplitude;	///< wave amplitude
  float freq;		///< number of waves
  float phase;		///< wave speed
  float transparency;	///< water transparency
  float fogdensity;	///< fog density

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Water(char *l);

  static WObject * (creator)(char *l);

  virtual void changePermanent(float lasting);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void render();
};

void WATER_INIT(void);

#endif // WATER_H
