#include "global.h"
#include "wo.h"

#include "net.h"	// NetObjectId


static const WClass end(END_TYPE, "End", NULL);

// global variables
WClass** WClass::objects_table = NULL;
int WClass::table_size = 0;


// WClass constructor
WClass::WClass(uint8_t _tid, const char* _name, 
	       WCreator _creator, WReplicator _replicator, WBuiltin _builtin) :
  type_id(_tid),
  type_name(_name),
  creator(_creator),
  replicator(_replicator),
  builtin(_builtin)
{
  if (type_id >= table_size) {
    int new_table_size = type_id + 1;
    objects_table =
      (WClass**) realloc(objects_table, sizeof(WClass*) * new_table_size);
    for (int i = table_size; i < new_table_size; i++)
      objects_table[i] = NULL;
    table_size = new_table_size;
  }
  objects_table[type_id] = this;
  trace(DBG_WO, "WClass: type_id=%d name=%s table=%p", type_id, _name, this);
}

void WClass::dumpTable()
{
  for (int i=0; i < table_size; i++) {
    printf("%02d: %p %02d %s\n", i, objects_table[i], objects_table[i]->type_id, objects_table[i]->type_name);
  }
}

const WClass * WClass::getWClass(uint8_t type_id)
{
  if (type_id < table_size)
    return objects_table[type_id];
  error("getWClass: type_id=%d out of bounds", type_id);
  dumpTable();
  return NULL;
}

const WClass * WClass::getWClass(const char *type_name)
{
  for (int i=0; i < table_size; i++) {
    if (objects_table[i]
        && type_name
        && strcasecmp(type_name, objects_table[i]->type_name) == 0)
	  return objects_table[i];
  }
  error("getWClass: type_name=%s not found in table", type_name);
  dumpTable();
  return NULL;
}

WObject * WClass::creatorInstance(const uint8_t type_id, char *l)
{
  if (isValidType(type_id)) {
    return objects_table[type_id]->creator(l);
  }
  error("creatorInstance: type_id=%d out of bounds", type_id);
  dumpTable();
  return NULL;
}

void WClass::builtinInstance(const uint8_t type_id)
{
  if (isValidType(type_id))
    objects_table[type_id]->builtin();
  else
    error("builtinInstance: type_id=%d out of bounds", type_id);
}

WObject * WClass::replicatorInstance(const uint8_t type_id, NetObjectId noid, Payload *pp)
{
  if (isValidType(type_id))
    return objects_table[type_id]->replicator(type_id, noid, pp);
  error("replicatorInstance: type_id=%d out of bounds", type_id);
  dumpTable();
  return NULL;
}
