// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tag1valuen.h
// 
// Purpose:     
// 
// Created:     3 Dec 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// formerly called "Till Vollmer's HeaderFields" from libHgHttp.a
// 
// $Id: tag1valuen.h,v 1.1 1997/03/03 10:00:07 root Exp $
// 
// $Log: tag1valuen.h,v $
// Revision 1.1  1997/03/03 10:00:07  root
// Initial revision
//
// 
// </file> 
#ifndef hg_utils_tag1valuen_h
#define hg_utils_tag1valuen_h 

#include "arrays.h"
#include "strfield.h"

class OBuffer ;

class OneTagNValues {
public:
   OneTagNValues(){};
   OneTagNValues (const RString& key) : key_(key) {}
   OneTagNValues (const RString& key, const RString& value):key_(key){insert(value);}
   OneTagNValues(const RString& key,const RStringField& values):key_(key),values_(values){}

   bool operator ==(const OneTagNValues& it) const ;
   bool operator !=(const OneTagNValues& it) const {return !(it.key_==key_);}
   bool operator <(const OneTagNValues& it) const ;

   const RString& value() const {if (values_.count()) return values_[0]; else return empty_;}
   const RStringField& values() const {return values_;}
   const RString& key()const {return key_;}

   void insert (const RString& value);
   void insert (const RStringField& values);

private:
   RString key_;
   RStringField values_;
   static const RString empty_;
} ;

Arraysdeclare (OneTagNValuesArray, OneTagNValues) ;

class TagAndValues : private OneTagNValuesArray {
public:
   TagAndValues() {}

   // you have to pass the tag/value separator length, that of the
   // line separator (separating 2 tag/value pairs, and an optional
   // terminator.
   int length (int tvsep, int linesep, int term) const ;
    
   void insert (const OneTagNValues&) ;
   void override (const OneTagNValues&) ;
   bool element (const RString& key, OneTagNValues&) const ;
   bool element (const RString& key) const;

   void write (OBuffer&, 
               const RString& tvsep, const RString& linesep, const RString& term) const ;
   void write (RString&, 
               const RString& tvsep, const RString& linesep, const RString& term) const ;
   void write (char*,
               const RString& tvsep, const RString& linesep, const RString& term) const ;
};


#endif
